/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.tools.st;

import io.github.applecommander.bastools.api.shapes.Shape;
import io.github.applecommander.bastools.api.shapes.ShapeExporter;
import io.github.applecommander.bastools.api.shapes.ShapeTable;
import io.github.applecommander.bastools.api.shapes.exporters.TextShapeExporter;
import io.github.applecommander.bastools.tools.st.IntegerRangeTypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import picocli.CommandLine;

@CommandLine.Command(name="extract", description={"Extract shapes from shape table"}, parameterListHeading="%nParameters:%n", descriptionHeading="%n", optionListHeading="%nOptions:%n")
public class ExtractCommand
implements Callable<Void> {
    @CommandLine.Option(names={"-h", "--help"}, description={"Show help for subcommand"}, usageHelp=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--stdin"}, description={"Read from stdin"})
    private boolean stdinFlag;
    @CommandLine.Option(names={"--stdout"}, description={"Write to stdout"})
    private boolean stdoutFlag;
    @CommandLine.Option(names={"-o", "--output"}, description={"Write output to file"})
    private Path outputFile;
    @CommandLine.Option(names={"--border"}, description={"Set border style (none, simple, box)"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String borderStyle = "simple";
    @CommandLine.Option(names={"--format"}, description={"Select output format (text, source, png, gif, jpeg, bmp, wbmp)"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String outputFormat = "text";
    @CommandLine.Option(names={"--coding"}, description={"Select source style (bitmap, long, short)"}, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String codeStyle = "long";
    @CommandLine.Option(names={"-O", "--optimize"}, description={"Optimize vector shapes (source only)"})
    private boolean optimize;
    @CommandLine.Option(names={"--skip-empty"}, description={"Skip empty shapes"})
    private boolean skipEmptyShapesFlag = false;
    @CommandLine.Option(names={"-w", "--width"}, description={"Set width (defaults: text=80, image=1024)"})
    private int width = -1;
    @CommandLine.Option(names={"--shapes"}, description={"Extract specific shape(s); formats are '1' or '1-4' and can be combined with a comma"}, converter={IntegerRangeTypeConverter.class})
    private List<Integer> shapeNums = new ArrayList();
    @CommandLine.Parameters(arity="0..1", description={"File to process"})
    private Path inputFile;
    private TextShapeExporter.BorderStrategy borderStrategy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws IOException {
        ShapeTable shapeTable;
        ShapeExporter exporter = this.validateAndParseArguments();
        ShapeTable shapeTable2 = shapeTable = this.stdinFlag ? ShapeTable.read((InputStream)System.in) : ShapeTable.read((Path)this.inputFile);
        if (this.shapeNums.isEmpty()) {
            if (this.stdoutFlag) {
                exporter.export(shapeTable, (OutputStream)System.out);
            } else {
                exporter.export(shapeTable, this.outputFile);
            }
        } else {
            List outOfRange = this.shapeNums.stream().filter(n -> n > shapeTable.shapes.size()).collect(Collectors.toList());
            if (!outOfRange.isEmpty()) {
                throw new IOException("Invalid shape numbers: " + outOfRange);
            }
            OutputStream outputStream = System.out;
            try {
                if (this.outputFile != null) {
                    outputStream = Files.newOutputStream(this.outputFile, new OpenOption[0]);
                }
                Iterator iterator = this.shapeNums.iterator();
                while (iterator.hasNext()) {
                    int shapeNum = (Integer)iterator.next();
                    Shape shape = (Shape)shapeTable.shapes.get(shapeNum - 1);
                    exporter.export(shape, outputStream);
                }
            }
            finally {
                if (this.outputFile != null) {
                    outputStream.close();
                }
            }
        }
        return null;
    }

    private ShapeExporter validateAndParseArguments() throws IOException {
        if (this.stdoutFlag && this.outputFile != null) {
            throw new IOException("Please choose one of stdout or output file");
        }
        if (this.stdinFlag && this.inputFile != null || !this.stdinFlag && this.inputFile == null) {
            throw new IOException("Please select ONE of stdin or file");
        }
        if (!this.stdoutFlag && this.outputFile == null) {
            this.outputFile = Paths.get("shapes.txt", new String[0]);
        }
        switch (this.borderStyle) {
            case "box": {
                this.borderStrategy = TextShapeExporter.BorderStrategy.BOX_DRAWING;
                break;
            }
            case "simple": {
                this.borderStrategy = TextShapeExporter.BorderStrategy.ASCII_TEXT;
                break;
            }
            case "none": {
                this.borderStrategy = TextShapeExporter.BorderStrategy.NONE;
                break;
            }
            default: {
                throw new IOException("Please select a valid border strategy");
            }
        }
        ShapeExporter exporter = null;
        block19 : switch (this.outputFormat) {
            case "text": {
                exporter = ShapeExporter.text().borderStrategy(this.borderStrategy).maxWidth(this.width == -1 ? 80 : this.width).skipEmptyShapes(this.skipEmptyShapesFlag).build();
                break;
            }
            case "png": 
            case "jpeg": 
            case "gif": 
            case "bmp": 
            case "wbmp": {
                exporter = ShapeExporter.image().border(this.borderStrategy != TextShapeExporter.BorderStrategy.NONE).maxWidth(this.width == -1 ? 1024 : this.width).imageFormat(this.outputFormat).skipEmptyShapes(this.skipEmptyShapesFlag).build();
                break;
            }
            case "source": {
                switch (this.codeStyle) {
                    case "bitmap": {
                        exporter = ShapeExporter.source().bitmap().skipEmptyShapes(this.skipEmptyShapesFlag).optimize(this.optimize).build();
                        break block19;
                    }
                    case "short": {
                        exporter = ShapeExporter.source().shortCommands().skipEmptyShapes(this.skipEmptyShapesFlag).optimize(this.optimize).build();
                        break block19;
                    }
                    case "long": {
                        exporter = ShapeExporter.source().longCommands().skipEmptyShapes(this.skipEmptyShapesFlag).optimize(this.optimize).build();
                        break block19;
                    }
                }
                throw new IOException("Please select a valid code style");
            }
            default: {
                throw new IOException("Please select a valid output format");
            }
        }
        return exporter;
    }
}

