/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="ArrayEquals", summary="Reference equality used to compare arrays", explanation="Generally when comparing arrays for equality, the programmer intends to check that the the contents of the arrays are equal rather than that they are actually the same object.  But many commonly used equals methods compare arrays for reference equality rather than content equality. These include the instance .equals() method, Guava's com.google.common.base.Objects#equal(), JDK's java.util.Objects#equals(), and Android's android.support.v4.util.ObjectsCompat#equals.\n\nIf reference equality is needed, == should be used instead for clarity. Otherwise, use java.util.Arrays#equals() to compare the contents of the arrays.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ArrayEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> instanceEqualsMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onClass(TypePredicates.isArray()).named("equals"), Matchers.argument((int)0, (Matcher)Matchers.isArrayType())});
    private static final Matcher<MethodInvocationTree> staticEqualsMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("android.support.v4.util.ObjectsCompat").named("equals"), Matchers.staticMethod().onClass("com.google.common.base.Objects").named("equal"), Matchers.staticMethod().onClass("java.util.Objects").named("equals")}), Matchers.argument((int)0, (Matcher)Matchers.isArrayType()), Matchers.argument((int)1, (Matcher)Matchers.isArrayType())});

    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        String arg2;
        String arg1;
        if (instanceEqualsMatcher.matches((Tree)t, state)) {
            arg1 = ((JCTree.JCFieldAccess)t.getMethodSelect()).getExpression().toString();
            arg2 = t.getArguments().get(0).toString();
        } else if (staticEqualsMatcher.matches((Tree)t, state)) {
            arg1 = t.getArguments().get(0).toString();
            arg2 = t.getArguments().get(1).toString();
        } else {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.builder().replace((Tree)t, "Arrays.equals(" + arg1 + ", " + arg2 + ")").addImport("java.util.Arrays").build();
        return this.describeMatch(t, (Fix)fix);
    }
}

