/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import proguard.classfile.ProgramClass;
import proguard.classfile.io.ProgramClassWriter;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.RenamedDataEntry;

public class DataEntryClassWriter
extends SimplifiedVisitor
implements ClassVisitor {
    private final DataEntryWriter dataEntryWriter;
    private final DataEntry templateDataEntry;

    public DataEntryClassWriter(DataEntryWriter dataEntryWriter, DataEntry dataEntry) {
        this.dataEntryWriter = dataEntryWriter;
        this.templateDataEntry = dataEntry;
    }

    public void visitProgramClass(ProgramClass programClass) {
        String string = programClass.getName();
        RenamedDataEntry renamedDataEntry = new RenamedDataEntry(this.templateDataEntry, string + ".class");
        try {
            OutputStream outputStream = this.dataEntryWriter.getOutputStream(renamedDataEntry);
            if (outputStream != null) {
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                new ProgramClassWriter(dataOutputStream).visitProgramClass(programClass);
                dataOutputStream.flush();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Can't write program class [" + string + "] to [" + renamedDataEntry + "] (" + iOException.getMessage() + ")", iOException);
        }
    }
}

