/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.instrumentation.stats.ContextUtils;
import com.google.instrumentation.stats.MeasurementMap;
import com.google.instrumentation.stats.RpcConstants;
import com.google.instrumentation.stats.StatsContext;
import com.google.instrumentation.stats.StatsContextFactory;
import com.google.instrumentation.stats.TagValue;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class CensusStatsModule {
    private static final Logger logger = Logger.getLogger(CensusStatsModule.class.getName());
    private static final double NANOS_PER_MILLI = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ClientTracer BLANK_CLIENT_TRACER = new ClientTracer();
    private final StatsContextFactory statsCtxFactory;
    private final Supplier<Stopwatch> stopwatchSupplier;
    @VisibleForTesting
    final Metadata.Key<StatsContext> statsHeader;
    private final StatsClientInterceptor clientInterceptor = new StatsClientInterceptor();
    private final ServerTracerFactory serverTracerFactory = new ServerTracerFactory();
    private final boolean propagateTags;

    CensusStatsModule(final StatsContextFactory statsCtxFactory, Supplier<Stopwatch> stopwatchSupplier, boolean propagateTags) {
        this.statsCtxFactory = (StatsContextFactory)Preconditions.checkNotNull((Object)statsCtxFactory, (Object)"statsCtxFactory");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        this.propagateTags = propagateTags;
        this.statsHeader = Metadata.Key.of("grpc-tags-bin", new Metadata.BinaryMarshaller<StatsContext>(){

            @Override
            public byte[] toBytes(StatsContext context) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    context.serialize((OutputStream)buffer);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return buffer.toByteArray();
            }

            @Override
            public StatsContext parseBytes(byte[] serialized) {
                try {
                    return statsCtxFactory.deserialize((InputStream)new ByteArrayInputStream(serialized));
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Failed to parse stats header", e);
                    return statsCtxFactory.getDefault();
                }
            }
        });
    }

    @VisibleForTesting
    ClientCallTracer newClientCallTracer(StatsContext parentCtx, String fullMethodName) {
        return new ClientCallTracer(parentCtx, fullMethodName);
    }

    ServerStreamTracer.Factory getServerTracerFactory() {
        return this.serverTracerFactory;
    }

    ClientInterceptor getClientInterceptor() {
        return this.clientInterceptor;
    }

    @VisibleForTesting
    final class StatsClientInterceptor
    implements ClientInterceptor {
        StatsClientInterceptor() {
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            StatsContext parentCtx = CensusStatsModule.this.statsCtxFactory.getCurrentStatsContext();
            final ClientCallTracer tracerFactory = CensusStatsModule.this.newClientCallTracer(parentCtx, method.getFullMethodName());
            ClientCall<ReqT, RespT> call = next.newCall(method, callOptions.withStreamTracerFactory(tracerFactory));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    this.delegate().start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    @VisibleForTesting
    final class ServerTracerFactory
    extends ServerStreamTracer.Factory {
        ServerTracerFactory() {
        }

        @Override
        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            StatsContext parentCtx = headers.get(CensusStatsModule.this.statsHeader);
            if (parentCtx == null) {
                parentCtx = CensusStatsModule.this.statsCtxFactory.getDefault();
            }
            parentCtx = parentCtx.with(RpcConstants.RPC_SERVER_METHOD, TagValue.create((String)fullMethodName));
            return new ServerTracer(fullMethodName, parentCtx);
        }
    }

    private final class ServerTracer
    extends ServerStreamTracer {
        private final String fullMethodName;
        @Nullable
        private final StatsContext parentCtx;
        private final AtomicBoolean streamClosed = new AtomicBoolean(false);
        private final Stopwatch stopwatch;
        private final AtomicLong outboundMessageCount = new AtomicLong();
        private final AtomicLong inboundMessageCount = new AtomicLong();
        private final AtomicLong outboundWireSize = new AtomicLong();
        private final AtomicLong inboundWireSize = new AtomicLong();
        private final AtomicLong outboundUncompressedSize = new AtomicLong();
        private final AtomicLong inboundUncompressedSize = new AtomicLong();

        ServerTracer(String fullMethodName, StatsContext parentCtx) {
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName");
            this.parentCtx = (StatsContext)Preconditions.checkNotNull((Object)parentCtx, (Object)"parentCtx");
            this.stopwatch = ((Stopwatch)CensusStatsModule.this.stopwatchSupplier.get()).start();
        }

        @Override
        public void outboundWireSize(long bytes) {
            this.outboundWireSize.addAndGet(bytes);
        }

        @Override
        public void inboundWireSize(long bytes) {
            this.inboundWireSize.addAndGet(bytes);
        }

        @Override
        public void outboundUncompressedSize(long bytes) {
            this.outboundUncompressedSize.addAndGet(bytes);
        }

        @Override
        public void inboundUncompressedSize(long bytes) {
            this.inboundUncompressedSize.addAndGet(bytes);
        }

        @Override
        public void inboundMessage(int seqNo) {
            this.inboundMessageCount.incrementAndGet();
        }

        @Override
        public void outboundMessage(int seqNo) {
            this.outboundMessageCount.incrementAndGet();
        }

        @Override
        public void streamClosed(Status status) {
            if (!this.streamClosed.compareAndSet(false, true)) {
                return;
            }
            this.stopwatch.stop();
            long elapsedTimeNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            MeasurementMap.Builder builder = MeasurementMap.builder().put(RpcConstants.RPC_SERVER_SERVER_LATENCY, (double)elapsedTimeNanos / NANOS_PER_MILLI).put(RpcConstants.RPC_SERVER_RESPONSE_COUNT, (double)this.outboundMessageCount.get()).put(RpcConstants.RPC_SERVER_REQUEST_COUNT, (double)this.inboundMessageCount.get()).put(RpcConstants.RPC_SERVER_RESPONSE_BYTES, (double)this.outboundWireSize.get()).put(RpcConstants.RPC_SERVER_REQUEST_BYTES, (double)this.inboundWireSize.get()).put(RpcConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES, (double)this.outboundUncompressedSize.get()).put(RpcConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES, (double)this.inboundUncompressedSize.get());
            if (!status.isOk()) {
                builder.put(RpcConstants.RPC_SERVER_ERROR_COUNT, 1.0);
            }
            StatsContext ctx = (StatsContext)MoreObjects.firstNonNull((Object)this.parentCtx, (Object)CensusStatsModule.this.statsCtxFactory.getDefault());
            ctx.with(RpcConstants.RPC_STATUS, TagValue.create((String)status.getCode().toString())).record(builder.build());
        }

        @Override
        public Context filterContext(Context context) {
            if (this.parentCtx != CensusStatsModule.this.statsCtxFactory.getDefault()) {
                return context.withValue(ContextUtils.STATS_CONTEXT_KEY, (Object)this.parentCtx);
            }
            return context;
        }
    }

    @VisibleForTesting
    final class ClientCallTracer
    extends ClientStreamTracer.Factory {
        private final String fullMethodName;
        private final Stopwatch stopwatch;
        private final AtomicReference<ClientTracer> streamTracer = new AtomicReference();
        private final AtomicBoolean callEnded = new AtomicBoolean(false);
        private final StatsContext parentCtx;

        ClientCallTracer(StatsContext parentCtx, String fullMethodName) {
            this.parentCtx = (StatsContext)Preconditions.checkNotNull((Object)parentCtx, (Object)"parentCtx");
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName");
            this.stopwatch = ((Stopwatch)CensusStatsModule.this.stopwatchSupplier.get()).start();
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(CallOptions callOptions, Metadata headers) {
            ClientTracer tracer = new ClientTracer();
            Preconditions.checkState((boolean)this.streamTracer.compareAndSet(null, tracer), (Object)"Are you creating multiple streams per call? This class doesn't yet support this case.");
            if (CensusStatsModule.this.propagateTags) {
                headers.discardAll(CensusStatsModule.this.statsHeader);
                if (this.parentCtx != CensusStatsModule.this.statsCtxFactory.getDefault()) {
                    headers.put(CensusStatsModule.this.statsHeader, this.parentCtx);
                }
            }
            return tracer;
        }

        void callEnded(Status status) {
            if (!this.callEnded.compareAndSet(false, true)) {
                return;
            }
            this.stopwatch.stop();
            long roundtripNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            ClientTracer tracer = this.streamTracer.get();
            if (tracer == null) {
                tracer = BLANK_CLIENT_TRACER;
            }
            MeasurementMap.Builder builder = MeasurementMap.builder().put(RpcConstants.RPC_CLIENT_ROUNDTRIP_LATENCY, (double)roundtripNanos / NANOS_PER_MILLI).put(RpcConstants.RPC_CLIENT_REQUEST_COUNT, (double)tracer.outboundMessageCount.get()).put(RpcConstants.RPC_CLIENT_RESPONSE_COUNT, (double)tracer.inboundMessageCount.get()).put(RpcConstants.RPC_CLIENT_REQUEST_BYTES, (double)tracer.outboundWireSize.get()).put(RpcConstants.RPC_CLIENT_RESPONSE_BYTES, (double)tracer.inboundWireSize.get()).put(RpcConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES, (double)tracer.outboundUncompressedSize.get()).put(RpcConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES, (double)tracer.inboundUncompressedSize.get());
            if (!status.isOk()) {
                builder.put(RpcConstants.RPC_CLIENT_ERROR_COUNT, 1.0);
            }
            this.parentCtx.with(RpcConstants.RPC_CLIENT_METHOD, TagValue.create((String)this.fullMethodName), RpcConstants.RPC_STATUS, TagValue.create((String)status.getCode().toString())).record(builder.build());
        }
    }

    private static final class ClientTracer
    extends ClientStreamTracer {
        final AtomicLong outboundMessageCount = new AtomicLong();
        final AtomicLong inboundMessageCount = new AtomicLong();
        final AtomicLong outboundWireSize = new AtomicLong();
        final AtomicLong inboundWireSize = new AtomicLong();
        final AtomicLong outboundUncompressedSize = new AtomicLong();
        final AtomicLong inboundUncompressedSize = new AtomicLong();

        private ClientTracer() {
        }

        @Override
        public void outboundWireSize(long bytes) {
            this.outboundWireSize.addAndGet(bytes);
        }

        @Override
        public void inboundWireSize(long bytes) {
            this.inboundWireSize.addAndGet(bytes);
        }

        @Override
        public void outboundUncompressedSize(long bytes) {
            this.outboundUncompressedSize.addAndGet(bytes);
        }

        @Override
        public void inboundUncompressedSize(long bytes) {
            this.inboundUncompressedSize.addAndGet(bytes);
        }

        @Override
        public void inboundMessage(int seqNo) {
            this.inboundMessageCount.incrementAndGet();
        }

        @Override
        public void outboundMessage(int seqNo) {
            this.outboundMessageCount.incrementAndGet();
        }
    }
}

