/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SerializerAdapter<T>
extends Serializer<T> {
    private final ObjectCodec<T> codec;

    public SerializerAdapter(ObjectCodec<T> codec) {
        this.codec = codec;
    }

    public void write(Kryo kryo, Output output, T object) {
        try {
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)byteOutput);
            this.codec.serialize(object, codedOut);
            codedOut.flush();
            byte[] byteData = byteOutput.toByteArray();
            output.writeInt(byteData.length, true);
            output.writeBytes(byteData);
        }
        catch (SerializationException | IOException e) {
            throw new KryoException((Throwable)e);
        }
    }

    public T read(Kryo kryo, Input input, Class<T> unusedClass) {
        try {
            byte[] byteData = input.readBytes(input.readInt(true));
            return this.codec.deserialize(CodedInputStream.newInstance((byte[])byteData));
        }
        catch (SerializationException | IOException e) {
            throw new KryoException((Throwable)e);
        }
    }
}

