/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Node;
import lombok.ast.Statement;

public class If
extends AbstractNode
implements Statement {
    private AbstractNode condition = null;
    private AbstractNode statement = null;
    private AbstractNode elseStatement = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public Expression astCondition() {
        if (!(this.condition instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.condition);
    }

    public If astCondition(Expression condition) {
        if (condition == null) {
            throw new NullPointerException("condition is mandatory");
        }
        return this.rawCondition(condition);
    }

    public Node rawCondition() {
        return this.condition;
    }

    public If rawCondition(Node condition) {
        if (condition == this.condition) {
            return this;
        }
        if (condition != null) {
            this.adopt((AbstractNode)condition);
        }
        if (this.condition != null) {
            this.disown(this.condition);
        }
        this.condition = (AbstractNode)condition;
        return this;
    }

    public Statement astStatement() {
        if (!(this.statement instanceof Statement)) {
            return null;
        }
        return (Statement)((Object)this.statement);
    }

    public If astStatement(Statement statement) {
        if (statement == null) {
            throw new NullPointerException("statement is mandatory");
        }
        return this.rawStatement(statement);
    }

    public Node rawStatement() {
        return this.statement;
    }

    public If rawStatement(Node statement) {
        if (statement == this.statement) {
            return this;
        }
        if (statement != null) {
            this.adopt((AbstractNode)statement);
        }
        if (this.statement != null) {
            this.disown(this.statement);
        }
        this.statement = (AbstractNode)statement;
        return this;
    }

    public Statement astElseStatement() {
        if (!(this.elseStatement instanceof Statement)) {
            return null;
        }
        return (Statement)((Object)this.elseStatement);
    }

    public If astElseStatement(Statement elseStatement) {
        return this.rawElseStatement(elseStatement);
    }

    public Node rawElseStatement() {
        return this.elseStatement;
    }

    public If rawElseStatement(Node elseStatement) {
        if (elseStatement == this.elseStatement) {
            return this;
        }
        if (elseStatement != null) {
            this.adopt((AbstractNode)elseStatement);
        }
        if (this.elseStatement != null) {
            this.disown(this.elseStatement);
        }
        this.elseStatement = (AbstractNode)elseStatement;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.condition != null) {
            result.add(this.condition);
        }
        if (this.statement != null) {
            result.add(this.statement);
        }
        if (this.elseStatement != null) {
            result.add(this.elseStatement);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.condition == original) {
            this.rawCondition(replacement);
            return true;
        }
        if (this.statement == original) {
            this.rawStatement(replacement);
            return true;
        }
        if (this.elseStatement == original) {
            this.rawElseStatement(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.condition == child) {
            this.disown((AbstractNode)child);
            this.condition = null;
            return true;
        }
        if (this.statement == child) {
            this.disown((AbstractNode)child);
            this.statement = null;
            return true;
        }
        if (this.elseStatement == child) {
            this.disown((AbstractNode)child);
            this.elseStatement = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitIf(this)) {
            return;
        }
        if (this.condition != null) {
            this.condition.accept(visitor);
        }
        if (this.statement != null) {
            this.statement.accept(visitor);
        }
        if (this.elseStatement != null) {
            this.elseStatement.accept(visitor);
        }
        visitor.afterVisitIf(this);
        visitor.endVisit(this);
    }

    @Override
    public If copy() {
        If result = new If();
        if (this.condition != null) {
            result.rawCondition(this.condition.copy());
        }
        if (this.statement != null) {
            result.rawStatement(this.statement.copy());
        }
        if (this.elseStatement != null) {
            result.rawElseStatement(this.elseStatement.copy());
        }
        return result;
    }
}

