/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclint;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.doclint.Checker;
import com.sun.tools.doclint.Env;
import com.sun.tools.doclint.HtmlVersion;
import com.sun.tools.doclint.Messages;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.lang.model.element.Name;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class DocLint
implements Plugin {
    public static final String XMSGS_OPTION = "-Xmsgs";
    public static final String XMSGS_CUSTOM_PREFIX = "-Xmsgs:";
    private static final String STATS = "-stats";
    public static final String XIMPLICIT_HEADERS = "-XimplicitHeaders:";
    public static final String XCUSTOM_TAGS_PREFIX = "-XcustomTags:";
    public static final String XHTML_VERSION_PREFIX = "-XhtmlVersion:";
    public static final String XCHECK_PACKAGE = "-XcheckPackage:";
    public static final String SEPARATOR = ",";
    List<File> javacBootClassPath;
    List<File> javacClassPath;
    List<File> javacSourcePath;
    List<String> javacOpts;
    List<File> javacFiles;
    boolean needHelp = false;
    Env env;
    Checker checker;

    public static void main(String ... args) {
        DocLint dl = new DocLint();
        try {
            dl.run(args);
        }
        catch (BadArgs e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println(dl.localize("dc.main.ioerror", e.getLocalizedMessage()));
            System.exit(2);
        }
    }

    public void run(String ... args) throws BadArgs, IOException {
        PrintWriter out = new PrintWriter(System.out);
        try {
            this.run(out, args);
        }
        finally {
            out.flush();
        }
    }

    public void run(PrintWriter out, String ... args) throws BadArgs, IOException {
        this.env = new Env();
        this.processArgs(args);
        boolean noFiles = this.javacFiles.isEmpty();
        if (this.needHelp) {
            this.showHelp(out);
            if (noFiles) {
                return;
            }
        } else if (noFiles) {
            out.println(this.localize("dc.main.no.files.given", new Object[0]));
            return;
        }
        JavacTool tool = JavacTool.create();
        JavacFileManager fm = new JavacFileManager(new Context(), false, null);
        fm.setSymbolFileEnabled(false);
        if (this.javacBootClassPath != null) {
            fm.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.javacBootClassPath);
        }
        if (this.javacClassPath != null) {
            fm.setLocation(StandardLocation.CLASS_PATH, this.javacClassPath);
        }
        if (this.javacSourcePath != null) {
            fm.setLocation(StandardLocation.SOURCE_PATH, this.javacSourcePath);
        }
        JavaCompiler.CompilationTask task = tool.getTask((Writer)out, (JavaFileManager)fm, (DiagnosticListener)null, this.javacOpts, (Iterable)null, (Iterable)fm.getJavaFileObjectsFromFiles(this.javacFiles));
        Iterable<? extends CompilationUnitTree> units = ((JavacTask)task).parse();
        ((JavacTaskImpl)task).enter();
        this.env.init((JavacTask)task);
        this.checker = new Checker(this.env);
        DeclScanner ds = new DeclScanner(this.env){

            @Override
            void visitDecl(Tree tree, Name name) {
                TreePath p = this.getCurrentPath();
                DocCommentTree dc = this.env.trees.getDocCommentTree(p);
                DocLint.this.checker.scan(dc, p);
            }
        };
        ds.scan(units, null);
        this.reportStats(out);
        Context ctx = ((JavacTaskImpl)task).getContext();
        JavaCompiler c = JavaCompiler.instance(ctx);
        c.printCount("error", c.errorCount());
        c.printCount("warn", c.warningCount());
    }

    void processArgs(String ... args) throws BadArgs {
        this.javacOpts = new ArrayList<String>();
        this.javacFiles = new ArrayList<File>();
        if (args.length == 0) {
            this.needHelp = true;
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.matches("-Xmax(errs|warns)") && i + 1 < args.length) {
                if (args[++i].matches("[0-9]+")) {
                    this.javacOpts.add(arg);
                    this.javacOpts.add(args[i]);
                    continue;
                }
                throw new BadArgs("dc.bad.value.for.option", arg, args[i]);
            }
            if ((arg.equals("-target") || arg.equals("-source")) && i + 1 < args.length) {
                this.javacOpts.add(arg);
                this.javacOpts.add(args[++i]);
                continue;
            }
            if (arg.equals(STATS)) {
                this.env.messages.setStatsEnabled(true);
                continue;
            }
            if (arg.equals("-bootclasspath") && i + 1 < args.length) {
                this.javacBootClassPath = this.splitPath(args[++i]);
                continue;
            }
            if (arg.equals("-classpath") && i + 1 < args.length) {
                this.javacClassPath = this.splitPath(args[++i]);
                continue;
            }
            if (arg.equals("-cp") && i + 1 < args.length) {
                this.javacClassPath = this.splitPath(args[++i]);
                continue;
            }
            if (arg.equals("-sourcepath") && i + 1 < args.length) {
                this.javacSourcePath = this.splitPath(args[++i]);
                continue;
            }
            if (arg.equals(XMSGS_OPTION)) {
                this.env.messages.setOptions(null);
                continue;
            }
            if (arg.startsWith(XMSGS_CUSTOM_PREFIX)) {
                this.env.messages.setOptions(arg.substring(arg.indexOf(":") + 1));
                continue;
            }
            if (arg.startsWith(XCUSTOM_TAGS_PREFIX)) {
                this.env.setCustomTags(arg.substring(arg.indexOf(":") + 1));
                continue;
            }
            if (arg.startsWith(XHTML_VERSION_PREFIX)) {
                String argsVersion = arg.substring(arg.indexOf(":") + 1);
                HtmlVersion htmlVersion = HtmlVersion.getHtmlVersion(argsVersion);
                if (htmlVersion != null) {
                    this.env.setHtmlVersion(htmlVersion);
                    continue;
                }
                throw new BadArgs("dc.bad.value.for.option", arg, argsVersion);
            }
            if (arg.equals("-h") || arg.equals("-help") || arg.equals("--help") || arg.equals("-?") || arg.equals("-usage")) {
                this.needHelp = true;
                continue;
            }
            if (arg.startsWith("-")) {
                throw new BadArgs("dc.bad.option", arg);
            }
            while (i < args.length) {
                this.javacFiles.add(new File(args[i++]));
            }
        }
    }

    void showHelp(PrintWriter out) {
        String msg = this.localize("dc.main.usage", new Object[0]);
        for (String line : msg.split("\n")) {
            out.println(line);
        }
    }

    List<File> splitPath(String path) {
        ArrayList<File> files = new ArrayList<File>();
        for (String f : path.split(File.pathSeparator)) {
            if (f.length() <= 0) continue;
            files.add(new File(f));
        }
        return files;
    }

    @Override
    public String getName() {
        return "doclint";
    }

    @Override
    public void init(JavacTask task, String ... args) {
        this.init(task, args, true);
    }

    public void init(JavacTask task, String[] args, boolean addTaskListener) {
        this.env = new Env();
        for (String arg : args) {
            if (arg.equals(XMSGS_OPTION)) {
                this.env.messages.setOptions(null);
                continue;
            }
            if (arg.startsWith(XMSGS_CUSTOM_PREFIX)) {
                this.env.messages.setOptions(arg.substring(arg.indexOf(":") + 1));
                continue;
            }
            if (arg.matches("-XimplicitHeaders:[1-6]")) {
                char ch = arg.charAt(arg.length() - 1);
                this.env.setImplicitHeaders(Character.digit(ch, 10));
                continue;
            }
            if (arg.startsWith(XCUSTOM_TAGS_PREFIX)) {
                this.env.setCustomTags(arg.substring(arg.indexOf(":") + 1));
                continue;
            }
            if (arg.startsWith(XHTML_VERSION_PREFIX)) {
                String argsVersion = arg.substring(arg.indexOf(":") + 1);
                HtmlVersion htmlVersion = HtmlVersion.getHtmlVersion(argsVersion);
                if (htmlVersion != null) {
                    this.env.setHtmlVersion(htmlVersion);
                    continue;
                }
                throw new IllegalArgumentException(argsVersion);
            }
            if (arg.startsWith(XCHECK_PACKAGE)) {
                this.env.setCheckPackages(arg.substring(arg.indexOf(":") + 1));
                continue;
            }
            throw new IllegalArgumentException(arg);
        }
        this.env.init(task);
        this.checker = new Checker(this.env);
        if (addTaskListener) {
            final DeclScanner ds = new DeclScanner(this.env){

                @Override
                void visitDecl(Tree tree, Name name) {
                    TreePath p = this.getCurrentPath();
                    DocCommentTree dc = this.env.trees.getDocCommentTree(p);
                    DocLint.this.checker.scan(dc, p);
                }
            };
            TaskListener tl = new TaskListener(){
                Queue<CompilationUnitTree> todo = new LinkedList<CompilationUnitTree>();

                @Override
                public void started(TaskEvent e) {
                    switch (e.getKind()) {
                        case ANALYZE: {
                            CompilationUnitTree tree;
                            while ((tree = this.todo.poll()) != null) {
                                ds.scan(tree, null);
                            }
                            break;
                        }
                    }
                }

                @Override
                public void finished(TaskEvent e) {
                    switch (e.getKind()) {
                        case PARSE: {
                            this.todo.add(e.getCompilationUnit());
                        }
                    }
                }
            };
            task.addTaskListener(tl);
        }
    }

    public void scan(TreePath p) {
        DocCommentTree dc = this.env.trees.getDocCommentTree(p);
        this.checker.scan(dc, p);
    }

    public boolean shouldCheck(CompilationUnitTree unit) {
        return this.env.shouldCheck(unit);
    }

    public void reportStats(PrintWriter out) {
        this.env.messages.reportStats(out);
    }

    public static boolean isValidOption(String opt) {
        if (opt.equals(XMSGS_OPTION)) {
            return true;
        }
        if (opt.startsWith(XMSGS_CUSTOM_PREFIX)) {
            return Messages.Options.isValidOptions(opt.substring(XMSGS_CUSTOM_PREFIX.length()));
        }
        if (opt.startsWith(XCHECK_PACKAGE)) {
            return Env.validatePackages(opt.substring(opt.indexOf(":") + 1));
        }
        return false;
    }

    private String localize(String code, Object ... args) {
        Messages m = this.env != null ? this.env.messages : new Messages(null);
        return m.localize(code, args);
    }

    static abstract class DeclScanner
    extends TreePathScanner<Void, Void> {
        final Env env;

        public DeclScanner(Env env) {
            this.env = env;
        }

        abstract void visitDecl(Tree var1, Name var2);

        @Override
        public Void visitPackage(PackageTree tree, Void ignore) {
            this.visitDecl(tree, null);
            return (Void)super.visitPackage(tree, ignore);
        }

        @Override
        public Void visitClass(ClassTree tree, Void ignore) {
            this.visitDecl(tree, tree.getSimpleName());
            return (Void)super.visitClass(tree, ignore);
        }

        @Override
        public Void visitMethod(MethodTree tree, Void ignore) {
            this.visitDecl(tree, tree.getName());
            return null;
        }

        @Override
        public Void visitModule(ModuleTree tree, Void ignore) {
            this.visitDecl(tree, null);
            return (Void)super.visitModule(tree, ignore);
        }

        @Override
        public Void visitVariable(VariableTree tree, Void ignore) {
            this.visitDecl(tree, tree.getName());
            return (Void)super.visitVariable(tree, ignore);
        }

        @Override
        public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
            if (!this.env.shouldCheck(node)) {
                return null;
            }
            return (Void)super.visitCompilationUnit(node, p);
        }
    }

    public class BadArgs
    extends Exception {
        private static final long serialVersionUID = 0L;
        final String code;
        final Object[] args;

        BadArgs(String code, Object ... args) {
            super(DocLint.this.localize(code, args));
            this.code = code;
            this.args = args;
        }
    }
}

