/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;

class Memoizer {
    private Memoizer() {
    }

    static class Deserializer {
        private final DeserializingMemoTable memo = new DeserializingMemoTable();
        @Nullable
        private Integer tagForMemoizedBefore = null;
        private final Deque<Object> memoizedBeforeStackForSanityChecking = new ArrayDeque<Object>();

        Deserializer() {
        }

        <T> T deserialize(DeserializationContext context, ObjectCodec<? extends T> codec, CodedInputStream codedIn) throws SerializationException, IOException {
            Preconditions.checkState((this.tagForMemoizedBefore == null ? 1 : 0) != 0, (String)"non-null memoized-before tag %s (%s)", (Object)this.tagForMemoizedBefore, codec);
            ObjectCodec.MemoizationStrategy strategy = codec.getStrategy();
            if (strategy == ObjectCodec.MemoizationStrategy.DO_NOT_MEMOIZE) {
                return codec.deserialize(context, codedIn);
            }
            switch (strategy) {
                case MEMOIZE_BEFORE: {
                    return this.deserializeMemoBeforeContent(context, codec, codedIn);
                }
                case MEMOIZE_AFTER: {
                    return this.deserializeMemoAfterContent(context, codec, codedIn);
                }
            }
            throw new AssertionError((Object)("Unreachable (strategy=" + (Object)((Object)strategy) + ")"));
        }

        Object getMemoized(int memoIndex) {
            return Preconditions.checkNotNull((Object)this.memo.lookup(memoIndex), (Object)memoIndex);
        }

        private <T> T safeCast(Object obj, ObjectCodec<T> codec) throws SerializationException {
            Class<?> objectClass;
            if (obj == null) {
                return null;
            }
            ImmutableSet expectedTypes = codec.additionalEncodedClasses().isEmpty() ? ImmutableSet.of(codec.getEncodedClass()) : ImmutableSet.builderWithExpectedSize((int)(codec.additionalEncodedClasses().size() + 1)).add(codec.getEncodedClass()).addAll(codec.additionalEncodedClasses()).build();
            if (expectedTypes.contains(objectClass = obj.getClass())) {
                Object checkedResult = obj;
                return (T)checkedResult;
            }
            for (Class expectedType : expectedTypes) {
                if (!expectedType.isAssignableFrom(objectClass)) continue;
                return expectedType.cast(obj);
            }
            throw new SerializationException("Object " + obj + ") has type " + objectClass.getName() + " but expected type one of " + expectedTypes);
        }

        private <T> T castedDeserialize(DeserializationContext context, ObjectCodec<T> codec, CodedInputStream codedIn) throws IOException, SerializationException {
            return this.safeCast(codec.deserialize(context, codedIn), codec);
        }

        <T> void registerInitialValue(T initialValue) {
            int tag = (Integer)Preconditions.checkNotNull((Object)this.tagForMemoizedBefore, (String)" Not called with memoize before: %s", initialValue);
            this.tagForMemoizedBefore = null;
            this.memo.memoize(tag, initialValue);
            this.memoizedBeforeStackForSanityChecking.addLast(initialValue);
        }

        private <T> T deserializeMemoBeforeContent(DeserializationContext context, ObjectCodec<T> codec, CodedInputStream codedIn) throws SerializationException, IOException {
            Object initial;
            this.tagForMemoizedBefore = codedIn.readInt32();
            T value = this.castedDeserialize(context, codec, codedIn);
            if (value != (initial = this.memoizedBeforeStackForSanityChecking.removeLast())) {
                throw new SerializationException(String.format("codec did not return the initial instance: %s but was %s with codec %s", value, initial, codec));
            }
            return value;
        }

        private <T> T deserializeMemoAfterContent(DeserializationContext context, ObjectCodec<T> codec, CodedInputStream codedIn) throws SerializationException, IOException {
            T value = this.castedDeserialize(context, codec, codedIn);
            int id = codedIn.readInt32();
            Object cyclicallyCreatedObject = this.memo.lookup(id);
            if (cyclicallyCreatedObject != null) {
                return this.safeCast(cyclicallyCreatedObject, codec);
            }
            this.memo.memoize(id, value);
            return value;
        }

        private static class DeserializingMemoTable {
            private HashMap<Integer, Object> table = new HashMap();

            private DeserializingMemoTable() {
            }

            private void memoize(int id, Object value) {
                Preconditions.checkNotNull((Object)value);
                Object prev = this.table.put(id, value);
                Preconditions.checkArgument((prev == null ? 1 : 0) != 0, (String)"Tried to memoize id %s to object '%s', when it is already memoized to object '%s'", (Object)id, (Object)value, (Object)prev);
            }

            @Nullable
            private Object lookup(int id) {
                return this.table.get(id);
            }
        }
    }

    static class Serializer {
        private final SerializingMemoTable memo = new SerializingMemoTable();

        Serializer() {
        }

        <T> void serialize(SerializationContext context, T obj, ObjectCodec<? super T> codec, CodedOutputStream codedOut) throws SerializationException, IOException {
            ObjectCodec.MemoizationStrategy strategy = codec.getStrategy();
            if (strategy == ObjectCodec.MemoizationStrategy.DO_NOT_MEMOIZE) {
                codec.serialize(context, obj, codedOut);
            } else {
                this.serializeMemoContent(context, obj, codec, codedOut, strategy);
            }
        }

        @Nullable
        Integer getMemoizedIndex(Object obj) {
            return this.memo.lookupNullable(obj);
        }

        private <T> void serializeMemoContent(SerializationContext context, T obj, ObjectCodec<T> codec, CodedOutputStream codedOut, ObjectCodec.MemoizationStrategy strategy) throws SerializationException, IOException {
            switch (strategy) {
                case MEMOIZE_BEFORE: {
                    int id = this.memo.memoize(obj);
                    codedOut.writeInt32NoTag(id);
                    codec.serialize(context, obj, codedOut);
                    break;
                }
                case MEMOIZE_AFTER: {
                    codec.serialize(context, obj, codedOut);
                    Integer cylicallyCreatedId = this.memo.lookupNullable(obj);
                    int id = cylicallyCreatedId != null ? cylicallyCreatedId : this.memo.memoize(obj);
                    codedOut.writeInt32NoTag(id);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unreachable (strategy=" + (Object)((Object)strategy) + ")"));
                }
            }
        }

        private static class SerializingMemoTable {
            private final IdentityHashMap<Object, Integer> table = new IdentityHashMap();

            private SerializingMemoTable() {
            }

            private int memoize(Object value) {
                Preconditions.checkArgument((!this.table.containsKey(value) ? 1 : 0) != 0, (String)"Tried to memoize object '%s' multiple times", (Object)value);
                int newId = this.table.size();
                this.table.put(value, newId);
                return newId;
            }

            @Nullable
            private Integer lookupNullable(Object value) {
                return this.table.get(value);
            }
        }
    }
}

