/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Internal;
import io.grpc.ManagedChannelProvider;
import io.grpc.ServerBuilder;
import java.util.ServiceLoader;

@Internal
public abstract class ServerProvider {
    private static final ServerProvider provider = ServerProvider.load(ServerProvider.class.getClassLoader());

    @VisibleForTesting
    static final ServerProvider load(ClassLoader cl) {
        ServiceLoader<ServerProvider> providers = ServiceLoader.load(ServerProvider.class, cl);
        if (!providers.iterator().hasNext()) {
            providers = ServiceLoader.load(ServerProvider.class);
        }
        ServerProvider best = null;
        for (ServerProvider current : providers) {
            if (!current.isAvailable()) continue;
            if (best == null) {
                best = current;
                continue;
            }
            if (current.priority() <= best.priority()) continue;
            best = current;
        }
        return best;
    }

    public static ServerProvider provider() {
        if (provider == null) {
            throw new ManagedChannelProvider.ProviderNotFoundException("No functional server found. Try adding a dependency on the grpc-netty artifact");
        }
        return provider;
    }

    protected abstract boolean isAvailable();

    protected abstract int priority();

    protected abstract ServerBuilder<?> builderForPort(int var1);
}

