/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import org.eclipse.aether.spi.localrepo.LocalRepositoryManagerFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;

@Named(value="simple")
public class SimpleLocalRepositoryManagerFactory
implements LocalRepositoryManagerFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private float priority;

    public SimpleLocalRepositoryManagerFactory() {
    }

    @Inject
    SimpleLocalRepositoryManagerFactory(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public LocalRepositoryManager newInstance(RepositorySystemSession session, LocalRepository repository) throws NoLocalRepositoryManagerException {
        if ("".equals(repository.getContentType()) || "simple".equals(repository.getContentType())) {
            return new SimpleLocalRepositoryManager(repository.getBasedir()).setLogger(this.logger);
        }
        throw new NoLocalRepositoryManagerException(repository);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((LoggerFactory)locator.getService(LoggerFactory.class));
    }

    public SimpleLocalRepositoryManagerFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger((LoggerFactory)loggerFactory, SimpleLocalRepositoryManager.class);
        return this;
    }

    public float getPriority() {
        return this.priority;
    }

    public SimpleLocalRepositoryManagerFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }
}

