/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableMapTestSuiteBuilder;
import com.google.common.collect.testing.SortedMapTestSuiteBuilder;
import com.google.common.collect.testing.TestEnumMapGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.testers.MapEntrySetTester;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import junit.framework.Test;
import junit.framework.TestSuite;

@GwtIncompatible
public class TestsForMapsInJavaUtil {
    public static Test suite() {
        return new TestsForMapsInJavaUtil().allTests();
    }

    public Test allTests() {
        TestSuite suite = new TestSuite("java.util Maps");
        suite.addTest(this.testsForCheckedMap());
        suite.addTest(this.testsForCheckedNavigableMap());
        suite.addTest(this.testsForCheckedSortedMap());
        suite.addTest(this.testsForEmptyMap());
        suite.addTest(this.testsForEmptyNavigableMap());
        suite.addTest(this.testsForEmptySortedMap());
        suite.addTest(this.testsForSingletonMap());
        suite.addTest(this.testsForHashMap());
        suite.addTest(this.testsForHashtable());
        suite.addTest(this.testsForLinkedHashMap());
        suite.addTest(this.testsForSynchronizedNavigableMap());
        suite.addTest(this.testsForTreeMapNatural());
        suite.addTest(this.testsForTreeMapWithComparator());
        suite.addTest(this.testsForUnmodifiableMap());
        suite.addTest(this.testsForUnmodifiableNavigableMap());
        suite.addTest(this.testsForUnmodifiableSortedMap());
        suite.addTest(this.testsForEnumMap());
        suite.addTest(this.testsForConcurrentHashMap());
        suite.addTest(this.testsForConcurrentSkipListMapNatural());
        suite.addTest(this.testsForConcurrentSkipListMapWithComparator());
        return suite;
    }

    protected Collection<Method> suppressForCheckedMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForCheckedNavigableMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForCheckedSortedMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForEmptyMap() {
        return Collections.emptySet();
    }

    private Collection<Method> suppressForEmptyNavigableMap() {
        return Collections.emptySet();
    }

    private Collection<Method> suppressForEmptySortedMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForSingletonMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForHashMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForHashtable() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForLinkedHashMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForSynchronizedNavigableMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForTreeMapNatural() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForTreeMapWithComparator() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForUnmodifiableMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForUnmodifiableNavigableMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForUnmodifiableSortedMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForEnumMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForConcurrentHashMap() {
        return Collections.emptySet();
    }

    protected Collection<Method> suppressForConcurrentSkipListMap() {
        return Arrays.asList(MapEntrySetTester.getSetValueMethod());
    }

    public Test testsForCheckedMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                Map map = TestsForMapsInJavaUtil.populate(new HashMap(), entries);
                return Collections.checkedMap(map, String.class, String.class);
            }
        }).named("checkedMap/HashMap")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.RESTRICTS_KEYS, MapFeature.RESTRICTS_VALUES, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForCheckedMap())).createTestSuite();
    }

    public Test testsForCheckedNavigableMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            protected NavigableMap<String, String> create(Map.Entry<String, String>[] entries) {
                NavigableMap map = (NavigableMap)TestsForMapsInJavaUtil.populate(new TreeMap(), entries);
                return Collections.checkedNavigableMap(map, String.class, String.class);
            }
        }).named("checkedNavigableMap/TreeMap, natural")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_VALUES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.RESTRICTS_KEYS, MapFeature.RESTRICTS_VALUES, CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForCheckedNavigableMap())).createTestSuite();
    }

    public Test testsForCheckedSortedMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            @Override
            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                SortedMap map = (SortedMap)TestsForMapsInJavaUtil.populate(new TreeMap(), entries);
                return Collections.checkedSortedMap(map, String.class, String.class);
            }
        }).named("checkedSortedMap/TreeMap, natural")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_VALUES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.RESTRICTS_KEYS, MapFeature.RESTRICTS_VALUES, CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForCheckedSortedMap())).createTestSuite();
    }

    public Test testsForEmptyMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return Collections.emptyMap();
            }
        }).named("emptyMap")).withFeatures(CollectionFeature.SERIALIZABLE, CollectionSize.ZERO)).suppressing(this.suppressForEmptyMap())).createTestSuite();
    }

    public Test testsForEmptyNavigableMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            protected NavigableMap<String, String> create(Map.Entry<String, String>[] entries) {
                return Collections.emptyNavigableMap();
            }
        }).named("emptyNavigableMap")).withFeatures(CollectionFeature.SERIALIZABLE, CollectionSize.ZERO)).suppressing(this.suppressForEmptyNavigableMap())).createTestSuite();
    }

    public Test testsForEmptySortedMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            @Override
            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                return Collections.emptySortedMap();
            }
        }).named("emptySortedMap")).withFeatures(CollectionFeature.SERIALIZABLE, CollectionSize.ZERO)).suppressing(this.suppressForEmptySortedMap())).createTestSuite();
    }

    public Test testsForSingletonMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return Collections.singletonMap(entries[0].getKey(), entries[0].getValue());
            }
        }).named("singletonMap")).withFeatures(MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.SERIALIZABLE, CollectionSize.ONE)).suppressing(this.suppressForSingletonMap())).createTestSuite();
    }

    public Test testsForHashMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return TestsForMapsInJavaUtil.toHashMap(entries);
            }
        }).named("HashMap")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForHashMap())).createTestSuite();
    }

    public Test testsForHashtable() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return TestsForMapsInJavaUtil.populate(new Hashtable(), entries);
            }
        }).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, MapFeature.RESTRICTS_KEYS, MapFeature.SUPPORTS_REMOVE, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SERIALIZABLE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.SUPPORTS_REMOVE, CollectionSize.ANY)).named("Hashtable")).suppressing(this.suppressForHashtable())).createTestSuite();
    }

    public Test testsForLinkedHashMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return TestsForMapsInJavaUtil.populate(new LinkedHashMap(), entries);
            }
        }).named("LinkedHashMap")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForLinkedHashMap())).createTestSuite();
    }

    public Test testsForSynchronizedNavigableMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            @Override
            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                NavigableMap delegate = (NavigableMap)TestsForMapsInJavaUtil.populate(new TreeMap(), entries);
                return Collections.synchronizedNavigableMap(delegate);
            }
        }).named("synchronizedNavigableMap/TreeMap, natural")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_VALUES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForSynchronizedNavigableMap())).createTestSuite();
    }

    public Test testsForTreeMapNatural() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            @Override
            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                return (SortedMap)TestsForMapsInJavaUtil.populate(new TreeMap(), entries);
            }
        }).named("TreeMap, natural")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_VALUES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForTreeMapNatural())).createTestSuite();
    }

    public Test testsForTreeMapWithComparator() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            @Override
            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                return (SortedMap)TestsForMapsInJavaUtil.populate(new TreeMap(TestsForMapsInJavaUtil.arbitraryNullFriendlyComparator()), entries);
            }
        }).named("TreeMap, with comparator")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForTreeMapWithComparator())).createTestSuite();
    }

    public Test testsForUnmodifiableMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return Collections.unmodifiableMap(TestsForMapsInJavaUtil.toHashMap(entries));
            }
        }).named("unmodifiableMap/HashMap")).withFeatures(MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForUnmodifiableMap())).createTestSuite();
    }

    public Test testsForUnmodifiableNavigableMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            protected NavigableMap<String, String> create(Map.Entry<String, String>[] entries) {
                return Collections.unmodifiableNavigableMap((NavigableMap)TestsForMapsInJavaUtil.populate(new TreeMap(), entries));
            }
        }).named("unmodifiableNavigableMap/TreeMap, natural")).withFeatures(MapFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForUnmodifiableNavigableMap())).createTestSuite();
    }

    public Test testsForUnmodifiableSortedMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            @Override
            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                SortedMap map = (SortedMap)TestsForMapsInJavaUtil.populate(new TreeMap(), entries);
                return Collections.unmodifiableSortedMap(map);
            }
        }).named("unmodifiableSortedMap/TreeMap, natural")).withFeatures(MapFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForUnmodifiableSortedMap())).createTestSuite();
    }

    public Test testsForEnumMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestEnumMapGenerator(){

            @Override
            protected Map<AnEnum, String> create(Map.Entry<AnEnum, String>[] entries) {
                return TestsForMapsInJavaUtil.populate(new EnumMap(AnEnum.class), entries);
            }
        }).named("EnumMap")).withFeatures(MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_VALUES, MapFeature.RESTRICTS_KEYS, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForEnumMap())).createTestSuite();
    }

    public Test testsForConcurrentHashMap() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using(new TestStringMapGenerator(){

            @Override
            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                return TestsForMapsInJavaUtil.populate(new ConcurrentHashMap(), entries);
            }
        }).named("ConcurrentHashMap")).withFeatures(MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForConcurrentHashMap())).createTestSuite();
    }

    public Test testsForConcurrentSkipListMapNatural() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            @Override
            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                return (SortedMap)TestsForMapsInJavaUtil.populate(new ConcurrentSkipListMap(), entries);
            }
        }).named("ConcurrentSkipListMap, natural")).withFeatures(MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForConcurrentSkipListMap())).createTestSuite();
    }

    public Test testsForConcurrentSkipListMapWithComparator() {
        return ((MapTestSuiteBuilder)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using(new TestStringSortedMapGenerator(){

            @Override
            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                return (SortedMap)TestsForMapsInJavaUtil.populate(new ConcurrentSkipListMap(TestsForMapsInJavaUtil.arbitraryNullFriendlyComparator()), entries);
            }
        }).named("ConcurrentSkipListMap, with comparator")).withFeatures(MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY)).suppressing(this.suppressForConcurrentSkipListMap())).createTestSuite();
    }

    private static Map<String, String> toHashMap(Map.Entry<String, String>[] entries) {
        return TestsForMapsInJavaUtil.populate(new HashMap(), entries);
    }

    private static <T, M extends Map<T, String>> M populate(M map, Map.Entry<T, String>[] entries) {
        for (Map.Entry<T, String> entry : entries) {
            map.put(entry.getKey(), (String)entry.getValue());
        }
        return map;
    }

    static <T> Comparator<T> arbitraryNullFriendlyComparator() {
        return new NullFriendlyComparator();
    }

    private static final class NullFriendlyComparator<T>
    implements Comparator<T>,
    Serializable {
        private NullFriendlyComparator() {
        }

        @Override
        public int compare(T left, T right) {
            return String.valueOf(left).compareTo(String.valueOf(right));
        }
    }
}

