/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import com.google.monitoring.runtime.instrumentation.AllocationMethodAdapter;
import com.google.monitoring.runtime.instrumentation.asm.ClassVisitor;
import com.google.monitoring.runtime.instrumentation.asm.MethodVisitor;
import com.google.monitoring.runtime.instrumentation.asm.commons.JSRInlinerAdapter;
import com.google.monitoring.runtime.instrumentation.asm.commons.LocalVariablesSorter;

class AllocationClassAdapter
extends ClassVisitor {
    private final String recorderClass;
    private final String recorderMethod;

    public AllocationClassAdapter(ClassVisitor cv, String recorderClass, String recorderMethod) {
        super(327680, cv);
        this.recorderClass = recorderClass;
        this.recorderMethod = recorderMethod;
    }

    @Override
    public MethodVisitor visitMethod(int access, String base, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, base, desc, signature, exceptions);
        if (mv != null) {
            LocalVariablesSorter lvs;
            JSRInlinerAdapter jsria = new JSRInlinerAdapter(mv, access, base, desc, signature, exceptions);
            AllocationMethodAdapter aimv = new AllocationMethodAdapter(jsria, this.recorderClass, this.recorderMethod);
            aimv.lvs = lvs = new LocalVariablesSorter(access, desc, aimv);
            mv = lvs;
        }
        return mv;
    }
}

