/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MultisetReadsTester<E>
extends AbstractMultisetTester<E> {
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testElementSet_contains() {
        MultisetReadsTester.assertTrue((String)"multiset.elementSet().contains(present) returned false", (boolean)this.getMultiset().elementSet().contains(this.e0()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEntrySet_contains() {
        MultisetReadsTester.assertTrue((String)"multiset.entrySet() didn't contain [present, 1]", (boolean)this.getMultiset().entrySet().contains(Multisets.immutableEntry(this.e0(), (int)1)));
    }

    public void testEntrySet_contains_count0() {
        MultisetReadsTester.assertFalse((String)"multiset.entrySet() contains [missing, 0]", (boolean)this.getMultiset().entrySet().contains(Multisets.immutableEntry(this.e3(), (int)0)));
    }

    public void testEntrySet_contains_nonentry() {
        MultisetReadsTester.assertFalse((String)"multiset.entrySet() contains a non-entry", (boolean)this.getMultiset().entrySet().contains(this.e0()));
    }

    public void testEntrySet_twice() {
        MultisetReadsTester.assertEquals((String)"calling multiset.entrySet() twice returned unequal sets", (Object)this.getMultiset().entrySet(), (Object)this.getMultiset().entrySet());
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEntrySet_hashCode_size0() {
        MultisetReadsTester.assertEquals((String)"multiset.entrySet() has incorrect hash code", (int)0, (int)this.getMultiset().entrySet().hashCode());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testEntrySet_hashCode_size1() {
        MultisetReadsTester.assertEquals((String)"multiset.entrySet() has incorrect hash code", (int)(1 ^ this.e0().hashCode()), (int)this.getMultiset().entrySet().hashCode());
    }

    public void testEquals_yes() {
        MultisetReadsTester.assertTrue((String)"multiset doesn't equal a multiset with the same elements", (boolean)this.getMultiset().equals((Object)HashMultiset.create(this.getSampleElements())));
    }

    public void testEquals_differentSize() {
        HashMultiset other = HashMultiset.create(this.getSampleElements());
        other.add(this.e0());
        MultisetReadsTester.assertFalse((String)"multiset equals a multiset with a different size", (boolean)this.getMultiset().equals((Object)other));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_differentElements() {
        HashMultiset other = HashMultiset.create(this.getSampleElements());
        other.remove(this.e0());
        other.add(this.e3());
        MultisetReadsTester.assertFalse((String)"multiset equals a multiset with different elements", (boolean)this.getMultiset().equals((Object)other));
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testHashCode_size0() {
        MultisetReadsTester.assertEquals((String)"multiset has incorrect hash code", (int)0, (int)this.getMultiset().hashCode());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testHashCode_size1() {
        MultisetReadsTester.assertEquals((String)"multiset has incorrect hash code", (int)(1 ^ this.e0().hashCode()), (int)this.getMultiset().hashCode());
    }
}

