/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.Commented;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Position;
import java.util.Iterator;
import java.util.List;

public class Comments {
    public static ImmutableList<Commented<ExpressionTree>> findCommentsForArguments(NewClassTree newClassTree, VisitorState state) {
        return Comments.findCommentsForArguments(newClassTree, newClassTree.getArguments(), state);
    }

    public static ImmutableList<Commented<ExpressionTree>> findCommentsForArguments(MethodInvocationTree methodInvocationTree, VisitorState state) {
        return Comments.findCommentsForArguments(methodInvocationTree, methodInvocationTree.getArguments(), state);
    }

    private static ImmutableList<Commented<ExpressionTree>> findCommentsForArguments(Tree tree, List<? extends ExpressionTree> arguments, VisitorState state) {
        if (arguments.isEmpty()) {
            return ImmutableList.of();
        }
        CharSequence sourceCode = state.getSourceCode();
        int startPosition = ((JCTree)tree).getStartPosition();
        int endPosition = Comments.computeEndPosition(tree, sourceCode, state);
        CharSequence source = sourceCode.subSequence(startPosition, endPosition);
        int invocationEnd = state.getEndPosition(tree) - startPosition;
        ErrorProneTokens errorProneTokens = new ErrorProneTokens(source.toString(), state.context);
        ImmutableList<ErrorProneToken> tokens = errorProneTokens.getTokens();
        Position.LineMap lineMap = errorProneTokens.getLineMap();
        ArgumentTracker argumentTracker = new ArgumentTracker(arguments, startPosition, state, lineMap);
        TokenTracker tokenTracker = new TokenTracker(lineMap);
        argumentTracker.advance();
        for (ErrorProneToken token : tokens) {
            tokenTracker.advance(token);
            if (tokenTracker.atStartOfLine() && !tokenTracker.wasPreviousLineEmpty()) {
                for (Tokens.Comment c : token.comments()) {
                    if (tokenTracker.isCommentOnPreviousLine(c) && token.pos() <= argumentTracker.currentArgumentStartPosition && argumentTracker.isPreviousArgumentOnPreviousLine()) {
                        argumentTracker.addCommentToPreviousArgument(c);
                        continue;
                    }
                    if (c.getSourcePos(0) > invocationEnd && lineMap.getLineNumber(c.getSourcePos(0)) > lineMap.getLineNumber(argumentTracker.currentArgumentEndPosition)) continue;
                    argumentTracker.addCommentToCurrentArgument(c);
                }
            } else {
                argumentTracker.addAllCommentsToCurrentArgument(token.comments());
            }
            if (token.pos() < argumentTracker.currentArgumentEndPosition || token.kind() != Tokens.TokenKind.COMMA) continue;
            if (!argumentTracker.hasMoreArguments()) break;
            argumentTracker.advance();
        }
        return argumentTracker.build();
    }

    @VisibleForTesting
    static int computeEndPosition(Tree methodInvocationTree, CharSequence sourceCode, VisitorState state) {
        int invocationEnd = state.getEndPosition(methodInvocationTree);
        int nextNewLine = CharMatcher.is((char)'\n').indexIn(sourceCode, invocationEnd);
        if (nextNewLine == -1) {
            return invocationEnd;
        }
        if (CharMatcher.is((char)'/').matchesNoneOf(sourceCode.subSequence(invocationEnd, nextNewLine))) {
            return invocationEnd;
        }
        return state.getEndPosition(Comments.getNextNodeOrParent(methodInvocationTree, state));
    }

    private static Tree getNextNodeOrParent(Tree current, VisitorState state) {
        TreePath enclosingPath;
        Tree predecessorNode = current;
        for (enclosingPath = state.getPath(); enclosingPath != null && !(enclosingPath.getLeaf() instanceof BlockTree) && !(enclosingPath.getLeaf() instanceof ClassTree); enclosingPath = enclosingPath.getParentPath()) {
            predecessorNode = enclosingPath.getLeaf();
        }
        if (enclosingPath == null) {
            return state.getPath().getParentPath().getLeaf();
        }
        Tree parent = enclosingPath.getLeaf();
        if (parent instanceof BlockTree) {
            return Comments.after(predecessorNode, ((BlockTree)parent).getStatements(), parent);
        }
        if (parent instanceof ClassTree) {
            return Comments.after(predecessorNode, ((ClassTree)parent).getMembers(), parent);
        }
        return parent;
    }

    private static <T> T after(T target, Iterable<? extends T> iterable, T defaultValue) {
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext() && !iterator.next().equals(target)) {
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return defaultValue;
    }

    private static class ArgumentTracker {
        private final VisitorState state;
        private final Iterator<? extends ExpressionTree> argumentsIterator;
        private final int offset;
        private final Position.LineMap lineMap;
        private Commented.Builder<ExpressionTree> currentCommentedResultBuilder = null;
        private Commented.Builder<ExpressionTree> previousCommentedResultBuilder = null;
        private final ImmutableList.Builder<Commented<ExpressionTree>> resultBuilder = ImmutableList.builder();
        private int currentArgumentStartPosition = -1;
        private int currentArgumentEndPosition = -1;
        private int previousArgumentEndPosition = -1;

        ArgumentTracker(Iterable<? extends ExpressionTree> arguments, int offset, VisitorState state, Position.LineMap lineMap) {
            this.state = state;
            this.offset = offset;
            this.argumentsIterator = arguments.iterator();
            this.lineMap = lineMap;
        }

        void advance() {
            ExpressionTree nextArgument = this.argumentsIterator.next();
            this.currentArgumentEndPosition = this.state.getEndPosition(nextArgument) - this.offset;
            this.previousArgumentEndPosition = this.currentArgumentStartPosition;
            this.currentArgumentStartPosition = ((JCTree)((Object)nextArgument)).getStartPosition() - this.offset;
            if (this.previousCommentedResultBuilder != null) {
                this.resultBuilder.add(this.previousCommentedResultBuilder.build());
            }
            this.previousCommentedResultBuilder = this.currentCommentedResultBuilder;
            this.currentCommentedResultBuilder = Commented.builder().setTree(nextArgument);
        }

        ImmutableList<Commented<ExpressionTree>> build() {
            if (this.previousCommentedResultBuilder != null) {
                this.resultBuilder.add(this.previousCommentedResultBuilder.build());
            }
            if (this.currentCommentedResultBuilder != null) {
                this.resultBuilder.add(this.currentCommentedResultBuilder.build());
            }
            return this.resultBuilder.build();
        }

        boolean isPreviousArgumentOnPreviousLine() {
            return this.lineMap.getLineNumber(this.previousArgumentEndPosition) == this.lineMap.getLineNumber(this.currentArgumentStartPosition) - 1;
        }

        void addCommentToPreviousArgument(Tokens.Comment c) {
            this.previousCommentedResultBuilder.addComment(c, this.previousArgumentEndPosition);
        }

        void addCommentToCurrentArgument(Tokens.Comment c) {
            this.currentCommentedResultBuilder.addComment(c, this.currentArgumentStartPosition);
        }

        void addAllCommentsToCurrentArgument(Iterable<Tokens.Comment> comments) {
            this.currentCommentedResultBuilder.addAllComment(comments, this.currentArgumentStartPosition);
        }

        public boolean hasMoreArguments() {
            return this.argumentsIterator.hasNext();
        }
    }

    private static class TokenTracker {
        private final Position.LineMap lineMap;
        private int tokensOnCurrentLine = 0;
        private int currentLineNumber = -1;
        private boolean previousLineEmpty = true;

        TokenTracker(Position.LineMap lineMap) {
            this.lineMap = lineMap;
        }

        void advance(ErrorProneToken token) {
            int line = this.lineMap.getLineNumber(token.pos());
            if (line != this.currentLineNumber) {
                this.currentLineNumber = line;
                this.previousLineEmpty = this.tokensOnCurrentLine == 0;
                this.tokensOnCurrentLine = 0;
            } else {
                ++this.tokensOnCurrentLine;
            }
        }

        boolean isCommentOnPreviousLine(Tokens.Comment c) {
            int tokenLine = this.lineMap.getLineNumber(c.getSourcePos(0));
            return tokenLine == this.currentLineNumber - 1;
        }

        boolean atStartOfLine() {
            return this.tokensOnCurrentLine == 0;
        }

        boolean wasPreviousLineEmpty() {
            return this.previousLineEmpty;
        }
    }
}

