/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Verify;
import java.util.List;

public final class TypeNameClassifier {
    private TypeNameClassifier() {
    }

    static int typePrefixLength(List<String> nameParts) {
        TyParseState state = TyParseState.START;
        int typeLength = -1;
        for (int i = 0; i < nameParts.size() && (state = state.next(JavaCaseFormat.from(nameParts.get(i)))) != TyParseState.REJECT; ++i) {
            if (!state.isSingleUnit()) continue;
            typeLength = i;
        }
        return typeLength;
    }

    public static enum JavaCaseFormat {
        UPPERCASE,
        LOWERCASE,
        UPPER_CAMEL,
        LOWER_CAMEL;


        static JavaCaseFormat from(String name) {
            Verify.verify((!name.isEmpty() ? 1 : 0) != 0);
            boolean firstUppercase = false;
            boolean hasUppercase = false;
            boolean hasLowercase = false;
            boolean first = true;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (!Character.isAlphabetic(c)) continue;
                if (first) {
                    firstUppercase = Character.isUpperCase(c);
                    first = false;
                }
                hasUppercase |= Character.isUpperCase(c);
                hasLowercase |= Character.isLowerCase(c);
            }
            if (firstUppercase) {
                return hasLowercase ? UPPER_CAMEL : UPPERCASE;
            }
            return hasUppercase ? LOWER_CAMEL : LOWERCASE;
        }
    }

    private static enum TyParseState {
        START(false){

            @Override
            public TyParseState next(JavaCaseFormat n) {
                switch (n) {
                    case UPPERCASE: {
                        return AMBIGUOUS;
                    }
                    case LOWER_CAMEL: {
                        return REJECT;
                    }
                    case LOWERCASE: {
                        return START;
                    }
                    case UPPER_CAMEL: {
                        return TYPE;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        TYPE(true){

            @Override
            public TyParseState next(JavaCaseFormat n) {
                switch (n) {
                    case UPPERCASE: 
                    case LOWER_CAMEL: 
                    case LOWERCASE: {
                        return FIRST_STATIC_MEMBER;
                    }
                    case UPPER_CAMEL: {
                        return TYPE;
                    }
                }
                throw new AssertionError();
            }
        }
        ,
        FIRST_STATIC_MEMBER(true){

            @Override
            public TyParseState next(JavaCaseFormat n) {
                return REJECT;
            }
        }
        ,
        REJECT(false){

            @Override
            public TyParseState next(JavaCaseFormat n) {
                return REJECT;
            }
        }
        ,
        AMBIGUOUS(false){

            @Override
            public TyParseState next(JavaCaseFormat n) {
                switch (n) {
                    case UPPERCASE: {
                        return AMBIGUOUS;
                    }
                    case LOWER_CAMEL: 
                    case LOWERCASE: {
                        return REJECT;
                    }
                    case UPPER_CAMEL: {
                        return TYPE;
                    }
                }
                throw new AssertionError();
            }
        };

        private final boolean isSingleUnit;

        private TyParseState(boolean isSingleUnit) {
            this.isSingleUnit = isSingleUnit;
        }

        public boolean isSingleUnit() {
            return this.isSingleUnit;
        }

        public abstract TyParseState next(JavaCaseFormat var1);
    }
}

