/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import javax.lang.model.element.Modifier;

@BugPattern(name="MethodCanBeStatic", altNames={"static-method"}, summary="A private method that does not reference the enclosing instance can be static", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION)
public class MethodCanBeStatic
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (sym.isStatic() || sym.isConstructor() || sym.getModifiers().contains((Object)Modifier.NATIVE)) {
            return Description.NO_MATCH;
        }
        if (!sym.isPrivate()) {
            return Description.NO_MATCH;
        }
        switch (sym.owner.enclClass().getNestingKind()) {
            case TOP_LEVEL: {
                break;
            }
            case MEMBER: {
                if (!sym.owner.enclClass().hasOuterInstance()) break;
                return Description.NO_MATCH;
            }
            case LOCAL: 
            case ANONYMOUS: {
                return Description.NO_MATCH;
            }
        }
        if (CanBeStaticAnalyzer.referencesOuter(tree, sym, state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSubtype((Type)sym.owner.enclClass().type, (Type)state.getSymtab().serializableType, (VisitorState)state)) {
            switch (((Name)sym.getSimpleName()).toString()) {
                case "readObject": {
                    if (((List)sym.getParameters()).size() != 1 || !ASTHelpers.isSameType((Type)((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)sym.getParameters())).type, (Type)state.getTypeFromString("java.io.ObjectInputStream"), (VisitorState)state)) break;
                    return Description.NO_MATCH;
                }
                case "writeObject": {
                    if (((List)sym.getParameters()).size() != 1 || !ASTHelpers.isSameType((Type)((Symbol.VarSymbol)Iterables.getOnlyElement((Iterable)sym.getParameters())).type, (Type)state.getTypeFromString("java.io.ObjectOutputStream"), (VisitorState)state)) break;
                    return Description.NO_MATCH;
                }
                case "readObjectNoData": {
                    if (((List)sym.getParameters()).size() != 0) break;
                    return Description.NO_MATCH;
                }
            }
        }
        return this.describeMatch(tree.getModifiers(), (Fix)SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}));
    }
}

