/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.auto.value.AutoValue;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.errorprone.AutoValue_RefactoringCollection_RefactoringResult;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.JavacErrorDescriptionListener;
import com.google.errorprone.apply.DescriptionBasedDiff;
import com.google.errorprone.apply.FileDestination;
import com.google.errorprone.apply.FileSource;
import com.google.errorprone.apply.FsFileDestination;
import com.google.errorprone.apply.FsFileSource;
import com.google.errorprone.apply.ImportOrganizer;
import com.google.errorprone.apply.PatchFileDestination;
import com.google.errorprone.apply.SourceFile;
import com.google.errorprone.matchers.Description;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

class RefactoringCollection
implements DescriptionListener.Factory {
    private static final Logger logger = Logger.getLogger(RefactoringCollection.class.getName());
    private final Multimap<URI, DelegatingDescriptionListener> foundSources = HashMultimap.create();
    private final Path rootPath;
    private final FileDestination fileDestination;
    private final Function<URI, RefactoringResult> postProcess;
    private final DescriptionListener.Factory descriptionsFactory;
    private final ImportOrganizer importOrganizer;

    static RefactoringCollection refactor(ErrorProneOptions.PatchingOptions patchingOptions, Context context) {
        Function<URI, RefactoringResult> postProcess;
        FileDestination fileDestination;
        Path rootPath = RefactoringCollection.buildRootPath();
        if (patchingOptions.inPlace()) {
            fileDestination = new FsFileDestination(rootPath);
            postProcess = uri -> RefactoringResult.create(String.format("Refactoring changes were successfully applied to %s, please check the refactored code and recompile.", uri), RefactoringResultType.CHANGED);
        } else {
            Path baseDir = rootPath.resolve(patchingOptions.baseDirectory());
            final Path patchFilePath = baseDir.resolve("error-prone.patch");
            final PatchFileDestination patchFileDestination = new PatchFileDestination(baseDir, rootPath);
            postProcess = new Function<URI, RefactoringResult>(){
                private final AtomicBoolean first = new AtomicBoolean(true);

                @Override
                public RefactoringResult apply(URI uri) {
                    try {
                        RefactoringCollection.writePatchFile(this.first, uri, patchFileDestination, patchFilePath);
                        return RefactoringResult.create("Changes were written to " + patchFilePath + ". Please inspect the file and apply with: patch -p0 -u -i error-prone.patch", RefactoringResultType.CHANGED);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to emit patch file!", e);
                    }
                }
            };
            fileDestination = patchFileDestination;
        }
        ImportOrganizer importOrganizer = patchingOptions.importOrganizer();
        return new RefactoringCollection(rootPath, fileDestination, postProcess, importOrganizer, context);
    }

    private RefactoringCollection(Path rootPath, FileDestination fileDestination, Function<URI, RefactoringResult> postProcess, ImportOrganizer importOrganizer, Context context) {
        this.rootPath = rootPath;
        this.fileDestination = fileDestination;
        this.postProcess = postProcess;
        this.descriptionsFactory = JavacErrorDescriptionListener.providerForRefactoring(context);
        this.importOrganizer = importOrganizer;
    }

    private static Path buildRootPath() {
        Path root = (Path)Iterables.getFirst(FileSystems.getDefault().getRootDirectories(), null);
        if (root == null) {
            throw new RuntimeException("Can't find a root filesystem!");
        }
        return root;
    }

    @Override
    public DescriptionListener getDescriptionListener(Log log, JCTree.JCCompilationUnit compilation) {
        URI sourceFile = compilation.getSourceFile().toUri();
        DelegatingDescriptionListener delegate = new DelegatingDescriptionListener(this.descriptionsFactory.getDescriptionListener(log, compilation), DescriptionBasedDiff.createIgnoringOverlaps(compilation, this.importOrganizer));
        this.foundSources.put((Object)sourceFile, (Object)delegate);
        return delegate;
    }

    RefactoringResult applyChanges(URI uri) throws Exception {
        Collection listeners = this.foundSources.removeAll((Object)uri);
        if (listeners.isEmpty()) {
            return RefactoringResult.create("", RefactoringResultType.NO_CHANGES);
        }
        this.doApplyProcess(this.fileDestination, new FsFileSource(this.rootPath), listeners);
        return this.postProcess.apply(uri);
    }

    private static void writePatchFile(AtomicBoolean first, URI uri, PatchFileDestination fileDestination, Path patchFilePatch) throws IOException {
        String patchFile = fileDestination.patchFile(uri);
        if (patchFile != null) {
            if (first.compareAndSet(true, false)) {
                try {
                    Files.deleteIfExists(patchFilePatch);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            Files.write(patchFilePatch, patchFile.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
    }

    private void doApplyProcess(FileDestination fileDestination, FileSource fileSource, Collection<DelegatingDescriptionListener> listeners) {
        for (DelegatingDescriptionListener listener : listeners) {
            try {
                SourceFile file = fileSource.readFile(listener.base.getRelevantFileName());
                listener.base.applyDifferences(file);
                fileDestination.writeFile(file);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Failed to apply diff to file " + listener.base.getRelevantFileName(), e);
            }
        }
    }

    private final class DelegatingDescriptionListener
    implements DescriptionListener {
        final DescriptionBasedDiff base;
        final DescriptionListener listener;

        DelegatingDescriptionListener(DescriptionListener listener, DescriptionBasedDiff base) {
            this.listener = listener;
            this.base = base;
        }

        @Override
        public void onDescribed(Description description) {
            this.listener.onDescribed(description);
            this.base.onDescribed(description);
        }
    }

    static enum RefactoringResultType {
        NO_CHANGES,
        CHANGED;

    }

    @AutoValue
    static abstract class RefactoringResult {
        RefactoringResult() {
        }

        abstract String message();

        abstract RefactoringResultType type();

        private static RefactoringResult create(String message, RefactoringResultType type) {
            return new AutoValue_RefactoringCollection_RefactoringResult(message, type);
        }
    }
}

