/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.argumentselectiondefects;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ArgumentChangeFinder;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Changes;
import com.google.errorprone.bugpatterns.argumentselectiondefects.CreatesDuplicateCallHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Heuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.InvocationInfo;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Matchers;
import com.google.errorprone.bugpatterns.argumentselectiondefects.NameInCommentHeuristic;
import com.google.errorprone.bugpatterns.argumentselectiondefects.Parameter;
import com.google.errorprone.bugpatterns.argumentselectiondefects.ParameterPair;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.function.Function;
import javax.lang.model.element.ElementKind;

@BugPattern(name="AssertEqualsArgumentOrderChecker", summary="Arguments are swapped in assertEquals-like call", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class AssertEqualsArgumentOrderChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private final ArgumentChangeFinder argumentchangeFinder = ArgumentChangeFinder.builder().setDistanceFunction(AssertEqualsArgumentOrderChecker.buildDistanceFunction()).addHeuristic(AssertEqualsArgumentOrderChecker.changeMustBeBetterThanOriginal()).addHeuristic(new CreatesDuplicateCallHeuristic()).addHeuristic(new NameInCommentHeuristic()).build();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!Matchers.ASSERT_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        InvocationInfo invocationInfo = InvocationInfo.createFromMethodInvocation(tree, symbol, state);
        Changes changes = this.argumentchangeFinder.findChanges(invocationInfo);
        if (changes.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(invocationInfo.tree()).addFix((Fix)changes.buildPermuteArgumentsFix(invocationInfo)).addFix((Fix)changes.buildCommentArgumentsFix(invocationInfo)).build();
    }

    private static Function<ParameterPair, Double> buildDistanceFunction() {
        return new Function<ParameterPair, Double>(){

            @Override
            public Double apply(ParameterPair parameterPair) {
                Parameter formal = parameterPair.formal();
                Parameter actual = parameterPair.actual();
                String formalName = formal.name();
                String actualName = actual.name();
                if (formalName.equals("expected")) {
                    if (actual.constant() || AssertEqualsArgumentOrderChecker.isEnumIdentifier(actual)) {
                        return 0.0;
                    }
                    if (actualName.startsWith("expected")) {
                        return 0.0;
                    }
                    return 1.0;
                }
                if (formalName.equals("actual")) {
                    if (actual.constant() || AssertEqualsArgumentOrderChecker.isEnumIdentifier(actual)) {
                        return 1.0;
                    }
                    if (actualName.startsWith("actual")) {
                        return 0.0;
                    }
                    return 1.0;
                }
                return formal.index() == actual.index() ? 0.0 : Double.POSITIVE_INFINITY;
            }
        };
    }

    private static boolean isEnumIdentifier(Parameter parameter) {
        switch (parameter.kind()) {
            case IDENTIFIER: 
            case MEMBER_SELECT: {
                break;
            }
            default: {
                return false;
            }
        }
        Symbol.TypeSymbol typeSymbol = parameter.type().tsym;
        if (typeSymbol != null) {
            return typeSymbol.getKind() == ElementKind.ENUM;
        }
        return false;
    }

    private static Heuristic changeMustBeBetterThanOriginal() {
        return (changes, node, sym, state) -> changes.totalAssignmentCost() < changes.totalOriginalCost();
    }
}

