/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;

@BugPattern(name="CloseableProvides", summary="Providing Closeable resources makes their lifecycle unclear", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.NO_FIX)
public class CloseableProvides
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> CLOSEABLE_PROVIDES_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{InjectMatchers.hasProvidesAnnotation(), Matchers.methodReturns((Matcher)Matchers.isSubtypeOf((String)"java.io.Closeable"))});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!CLOSEABLE_PROVIDES_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

