/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@BugPattern(name="EmptySetMultibindingContributions", summary="@Multibinds is a more efficient and declarative mechanism for ensuring that a set multibinding is present in the graph.", severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class EmptySetMultibindingContributions
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<AnnotationTree> HAS_DAGGER_ONE_MODULE_ARGUMENT = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasArgumentWithValue((String)"injects", (Matcher)Matchers.anything()), Matchers.hasArgumentWithValue((String)"staticInjections", (Matcher)Matchers.anything()), Matchers.hasArgumentWithValue((String)"overrides", (Matcher)Matchers.anything()), Matchers.hasArgumentWithValue((String)"addsTo", (Matcher)Matchers.anything()), Matchers.hasArgumentWithValue((String)"complete", (Matcher)Matchers.anything()), Matchers.hasArgumentWithValue((String)"library", (Matcher)Matchers.anything())});
    private static final Matcher<ExpressionTree> COLLECTIONS_EMPTY_SET = MethodMatchers.staticMethod().onClass(Collections.class.getCanonicalName()).named("emptySet");
    private static final Matcher<ExpressionTree> IMMUTABLE_SETS_OF = MethodMatchers.staticMethod().onClassAny(new String[]{ImmutableSet.class.getCanonicalName(), ImmutableSortedSet.class.getCanonicalName()}).named("of").withParameters(new String[0]);
    private static final Matcher<ExpressionTree> SET_CONSTRUCTORS = Matchers.anyOf((Matcher[])new Matcher[]{EmptySetMultibindingContributions.noArgSetConstructor(HashSet.class), EmptySetMultibindingContributions.noArgSetConstructor(LinkedHashSet.class), EmptySetMultibindingContributions.noArgSetConstructor(TreeSet.class)});
    private static final Matcher<ExpressionTree> SET_FACTORY_METHODS = Matchers.anyOf((Matcher[])new Matcher[]{EmptySetMultibindingContributions.setFactory("newHashSet"), EmptySetMultibindingContributions.setFactory("newLinkedHashSet"), EmptySetMultibindingContributions.setFactory("newConcurrentHashSet")});
    private static final Matcher<ExpressionTree> ENUM_SET_NONE_OF = MethodMatchers.staticMethod().onClass(EnumSet.class.getCanonicalName()).named("noneOf");
    private static final Matcher<ExpressionTree> EMPTY_SET = Matchers.anyOf((Matcher[])new Matcher[]{COLLECTIONS_EMPTY_SET, IMMUTABLE_SETS_OF, SET_CONSTRUCTORS, SET_FACTORY_METHODS, ENUM_SET_NONE_OF});
    private static final Matcher<MethodTree> RETURNS_EMPTY_SET = new Matcher<MethodTree>(){

        public boolean matches(MethodTree method, VisitorState state) {
            List<? extends VariableTree> parameters = method.getParameters();
            if (!parameters.isEmpty()) {
                return false;
            }
            BlockTree body = method.getBody();
            if (body == null) {
                return false;
            }
            List<? extends StatementTree> statements = body.getStatements();
            if (statements.size() != 1) {
                return false;
            }
            StatementTree onlyStatement = (StatementTree)Iterables.getOnlyElement(statements);
            if (!onlyStatement.getKind().equals((Object)Tree.Kind.RETURN)) {
                return false;
            }
            return EMPTY_SET.matches((Tree)((ReturnTree)onlyStatement).getExpression(), state);
        }
    };
    private static final Matcher<Tree> ANNOTATED_WITH_PRODUCES_OR_PROVIDES = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"dagger.Provides"), Matchers.hasAnnotation((String)"dagger.producers.Produces")});
    private static final Matcher<MethodTree> CAN_BE_A_MULTIBINDS_METHOD = Matchers.allOf((Matcher[])new Matcher[]{ANNOTATED_WITH_PRODUCES_OR_PROVIDES, Matchers.hasAnnotation((String)"dagger.multibindings.ElementsIntoSet"), RETURNS_EMPTY_SET});

    private static Matcher<ExpressionTree> noArgSetConstructor(Class<? extends Set> setClass) {
        return MethodMatchers.constructor().forClass(setClass.getCanonicalName()).withParameters(new String[0]);
    }

    private static Matcher<ExpressionTree> setFactory(String factoryName) {
        return MethodMatchers.staticMethod().onClass(Sets.class.getCanonicalName()).named(factoryName).withParameters(new String[0]);
    }

    public Description matchMethod(MethodTree method, VisitorState state) {
        if (!CAN_BE_A_MULTIBINDS_METHOD.matches((Tree)method, state)) {
            return Description.NO_MATCH;
        }
        JCTree.JCClassDecl enclosingClass = (JCTree.JCClassDecl)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), JCTree.JCClassDecl.class);
        for (JCTree.JCAnnotation annotation : enclosingClass.getModifiers().getAnnotations()) {
            if (!ASTHelpers.getSymbol((Tree)annotation.getAnnotationType()).getQualifiedName().contentEquals("dagger.Module") || !HAS_DAGGER_ONE_MODULE_ARGUMENT.matches((Tree)annotation, state)) continue;
            return Description.NO_MATCH;
        }
        return this.fixByModifyingMethod(state, enclosingClass, method);
    }

    private Description fixByModifyingMethod(VisitorState state, JCTree.JCClassDecl enclosingClass, MethodTree method) {
        JCTree.JCModifiers methodModifiers = ((JCTree.JCMethodDecl)method).getModifiers();
        String replacementModifiersString = this.createReplacementMethodModifiers(state, methodModifiers);
        JCTree.JCModifiers enclosingClassModifiers = enclosingClass.getModifiers();
        String enclosingClassReplacementModifiersString = this.createReplacementClassModifiers(state, enclosingClassModifiers);
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder().addImport("dagger.multibindings.Multibinds").replace((Tree)methodModifiers, replacementModifiersString).replace((Tree)method.getBody(), ";");
        fixBuilder = enclosingClassModifiers.pos == -1 ? fixBuilder.prefixWith((Tree)enclosingClass, enclosingClassReplacementModifiersString) : fixBuilder.replace((Tree)enclosingClassModifiers, enclosingClassReplacementModifiersString);
        return this.describeMatch(method, (Fix)fixBuilder.build());
    }

    private Description fixByDelegating() {
        return Description.NO_MATCH;
    }

    private String createReplacementMethodModifiers(VisitorState state, JCTree.JCModifiers modifiers) {
        ImmutableList.Builder modifierStringsBuilder = ImmutableList.builder().add((Object)"@Multibinds");
        for (JCTree.JCAnnotation annotation : modifiers.annotations) {
            Name annotationQualifiedName = ASTHelpers.getSymbol((Tree)annotation).getQualifiedName();
            if (annotationQualifiedName.contentEquals("dagger.Provides") || annotationQualifiedName.contentEquals("dagger.producers.Produces") || annotationQualifiedName.contentEquals("dagger.multibindings.ElementsIntoSet")) continue;
            modifierStringsBuilder.add((Object)state.getSourceForNode((Tree)annotation));
        }
        EnumSet<Flags.Flag> methodFlags = Flags.asFlagSet(modifiers.flags);
        methodFlags.remove((Object)Flags.Flag.STATIC);
        methodFlags.remove((Object)Flags.Flag.FINAL);
        methodFlags.add(Flags.Flag.ABSTRACT);
        for (Flags.Flag flag : methodFlags) {
            modifierStringsBuilder.add((Object)flag.toString());
        }
        return Joiner.on((char)' ').join((Iterable)modifierStringsBuilder.build());
    }

    private String createReplacementClassModifiers(VisitorState state, JCTree.JCModifiers enclosingClassModifiers) {
        ImmutableList.Builder classModifierStringsBuilder = ImmutableList.builder();
        for (JCTree.JCAnnotation annotation : enclosingClassModifiers.annotations) {
            classModifierStringsBuilder.add((Object)state.getSourceForNode((Tree)annotation));
        }
        EnumSet<Flags.Flag> classFlags = Flags.asFlagSet(enclosingClassModifiers.flags);
        classFlags.remove((Object)Flags.Flag.FINAL);
        classFlags.add(Flags.Flag.ABSTRACT);
        for (Flags.Flag flag : classFlags) {
            classModifierStringsBuilder.add((Object)flag.toString());
        }
        return Joiner.on((char)' ').join((Iterable)classModifierStringsBuilder.build());
    }
}

