/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.StringMatcher;

public class VariableStringMatcher
extends StringMatcher {
    private final char[] allowedCharacters;
    private final char[] disallowedCharacters;
    private final int minimumLength;
    private final int maximumLength;
    private final StringMatcher nextMatcher;

    public VariableStringMatcher(char[] cArray, char[] cArray2, int n, int n2, StringMatcher stringMatcher) {
        this.allowedCharacters = cArray;
        this.disallowedCharacters = cArray2;
        this.minimumLength = n;
        this.maximumLength = n2;
        this.nextMatcher = stringMatcher;
    }

    @Override
    protected boolean matches(String string, int n, int n2) {
        int n3;
        if (n2 < this.minimumLength) {
            return false;
        }
        for (n3 = n; n3 < n + this.minimumLength; ++n3) {
            if (this.isAllowedCharacter(string.charAt(n3))) continue;
            return false;
        }
        n3 = Math.min(this.maximumLength, n2);
        for (int i = n + this.minimumLength; i < n + n3; ++i) {
            if (this.nextMatcher.matches(string, i, n2 + n - i)) {
                return true;
            }
            if (this.isAllowedCharacter(string.charAt(i))) continue;
            return false;
        }
        return this.nextMatcher.matches(string, n + n3, n2 - n3);
    }

    private boolean isAllowedCharacter(char c) {
        if (this.allowedCharacters != null) {
            for (int i = 0; i < this.allowedCharacters.length; ++i) {
                if (this.allowedCharacters[i] != c) continue;
                return true;
            }
            return false;
        }
        if (this.disallowedCharacters != null) {
            for (int i = 0; i < this.disallowedCharacters.length; ++i) {
                if (this.disallowedCharacters[i] != c) continue;
                return false;
            }
        }
        return true;
    }
}

