/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;

public class Source
implements Comparable<Source> {
    private Package pkg;
    private String name;
    private String suffix;
    private long lastModified;
    private File file;
    private boolean isGenerated;
    private boolean linkedOnly;

    public boolean equals(Object o) {
        return o instanceof Source && this.name.equals(((Source)o).name);
    }

    @Override
    public int compareTo(Source o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Source(Module m, String n, File f) {
        this.name = n;
        int dp = n.lastIndexOf(".");
        this.suffix = dp != -1 ? n.substring(dp) : "";
        this.file = f;
        this.lastModified = f.lastModified();
        this.linkedOnly = false;
    }

    public Source(Package p, String n, long lm) {
        this.pkg = p;
        this.name = n;
        int dp = n.lastIndexOf(".");
        this.suffix = dp != -1 ? n.substring(dp) : "";
        this.file = null;
        this.lastModified = lm;
        this.linkedOnly = false;
        int ls = n.lastIndexOf(47);
    }

    public String name() {
        return this.name;
    }

    public String suffix() {
        return this.suffix;
    }

    public Package pkg() {
        return this.pkg;
    }

    public File file() {
        return this.file;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setPackage(Package p) {
        this.pkg = p;
    }

    public void markAsGenerated() {
        this.isGenerated = true;
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public void markAsLinkedOnly() {
        this.linkedOnly = true;
    }

    public boolean isLinkedOnly() {
        return this.linkedOnly;
    }

    private void save(StringBuilder b) {
        String CL = this.linkedOnly ? "L" : "C";
        String GS = this.isGenerated ? "G" : "S";
        b.append(GS + " " + CL + " " + this.name + " " + this.file.lastModified() + "\n");
    }

    public static Source load(Package lastPackage, String l, boolean isGenerated) {
        int sp = l.indexOf(32, 4);
        if (sp == -1) {
            return null;
        }
        String name = l.substring(4, sp);
        long last_modified = Long.parseLong(l.substring(sp + 1));
        boolean isLinkedOnly = false;
        if (l.charAt(2) == 'L') {
            isLinkedOnly = true;
        } else if (l.charAt(2) == 'C') {
            isLinkedOnly = false;
        } else {
            return null;
        }
        Source s = new Source(lastPackage, name, last_modified);
        s.file = new File(name);
        if (isGenerated) {
            s.markAsGenerated();
        }
        if (isLinkedOnly) {
            s.markAsLinkedOnly();
        }
        return s;
    }

    public static void saveSources(Map<String, Source> sources, StringBuilder b) {
        ArrayList<String> sorted_sources = new ArrayList<String>();
        for (String key : sources.keySet()) {
            sorted_sources.add(key);
        }
        Collections.sort(sorted_sources);
        for (String key : sorted_sources) {
            Source s = sources.get(key);
            s.save(b);
        }
    }

    public static void scanRoot(final File root, final Set<String> suffixes, List<String> excludes, List<String> includes, final Map<String, Source> foundFiles, Map<String, Module> foundModules, final Module currentModule, boolean permitSourcesWithoutPackage, final boolean inGensrc, final boolean inLinksrc) throws IOException, ProblemException {
        if (root == null) {
            return;
        }
        FileSystem fs = root.toPath().getFileSystem();
        if (includes.isEmpty()) {
            includes = Collections.singletonList("**");
        }
        final List<PathMatcher> includeMatchers = Source.createPathMatchers(fs, includes);
        final List<PathMatcher> excludeMatchers = Source.createPathMatchers(fs, excludes);
        Files.walkFileTree(root.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relToRoot = root.toPath().relativize(file);
                if (!includeMatchers.stream().anyMatch(im -> im.matches(relToRoot)) || !excludeMatchers.stream().noneMatch(em -> em.matches(relToRoot)) || !suffixes.contains(Util.fileSuffix(file))) return FileVisitResult.CONTINUE;
                Source existing = (Source)foundFiles.get(file);
                if (existing != null) {
                    throw new IOException("You have already added the file " + file + " from " + existing.file().getPath());
                }
                existing = currentModule.lookupSource(file.toString());
                if (existing != null) {
                    if (!inLinksrc) throw new IOException("Internal error: Double add of file " + file + " from " + existing.file().getPath());
                    if (existing.isLinkedOnly()) {
                        throw new IOException("You have already added the link only file " + file + " from " + existing.file().getPath());
                    }
                    foundFiles.put(file.toString(), existing);
                    return FileVisitResult.CONTINUE;
                } else {
                    Source s = new Source(currentModule, file.toString(), file.toFile());
                    if (inGensrc) {
                        s.markAsGenerated();
                    }
                    if (inLinksrc) {
                        s.markAsLinkedOnly();
                    }
                    Object pkg = Source.packageOfJavaFile(root.toPath(), file);
                    pkg = currentModule.name() + ":" + (String)pkg;
                    foundFiles.put(file.toString(), s);
                    currentModule.addSource((String)pkg, s);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static List<PathMatcher> createPathMatchers(FileSystem fs, List<String> patterns) {
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>();
        for (String pattern : patterns) {
            try {
                matchers.add(fs.getPathMatcher("glob:" + pattern));
            }
            catch (PatternSyntaxException e) {
                Log.error("Invalid pattern: " + pattern);
                throw e;
            }
        }
        return matchers;
    }

    private static String packageOfJavaFile(Path sourceRoot, Path javaFile) {
        Path javaFileDir = javaFile.getParent();
        Path packageDir = sourceRoot.relativize(javaFileDir);
        ArrayList<String> separateDirs = new ArrayList<String>();
        for (Path pathElement : packageDir) {
            separateDirs.add(pathElement.getFileName().toString());
        }
        return String.join((CharSequence)".", separateDirs);
    }

    public String toString() {
        return String.format("%s[pkg: %s, name: %s, suffix: %s, file: %s, isGenerated: %b, linkedOnly: %b]", this.getClass().getSimpleName(), this.pkg, this.name, this.suffix, this.file, this.isGenerated, this.linkedOnly);
    }
}

