/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;

public class AttributesEditor {
    private final ProgramClass targetClass;
    private final ProgramMember targetMember;
    private final CodeAttribute targetAttribute;
    private final boolean replaceAttributes;

    public AttributesEditor(ProgramClass programClass, boolean bl) {
        this(programClass, null, null, bl);
    }

    public AttributesEditor(ProgramClass programClass, ProgramMember programMember, boolean bl) {
        this(programClass, programMember, null, bl);
    }

    public AttributesEditor(ProgramClass programClass, ProgramMember programMember, CodeAttribute codeAttribute, boolean bl) {
        this.targetClass = programClass;
        this.targetMember = programMember;
        this.targetAttribute = codeAttribute;
        this.replaceAttributes = bl;
    }

    public Attribute findAttribute(String string) {
        return this.targetAttribute != null ? this.findAttribute(this.targetAttribute.u2attributesCount, this.targetAttribute.attributes, string) : (this.targetMember != null ? this.findAttribute(this.targetMember.u2attributesCount, this.targetMember.attributes, string) : this.findAttribute(this.targetClass.u2attributesCount, this.targetClass.attributes, string));
    }

    public void addAttribute(Attribute attribute) {
        if (this.targetAttribute != null) {
            if (!this.replaceAttributes || !this.replaceAttribute(this.targetAttribute.u2attributesCount, this.targetAttribute.attributes, attribute)) {
                this.targetAttribute.attributes = this.addAttribute(this.targetAttribute.u2attributesCount, this.targetAttribute.attributes, attribute);
                ++this.targetAttribute.u2attributesCount;
            }
        } else if (this.targetMember != null) {
            if (!this.replaceAttributes || !this.replaceAttribute(this.targetMember.u2attributesCount, this.targetMember.attributes, attribute)) {
                this.targetMember.attributes = this.addAttribute(this.targetMember.u2attributesCount, this.targetMember.attributes, attribute);
                ++this.targetMember.u2attributesCount;
            }
        } else if (!this.replaceAttributes || !this.replaceAttribute(this.targetClass.u2attributesCount, this.targetClass.attributes, attribute)) {
            this.targetClass.attributes = this.addAttribute(this.targetClass.u2attributesCount, this.targetClass.attributes, attribute);
            ++this.targetClass.u2attributesCount;
        }
    }

    public void deleteAttribute(String string) {
        if (this.targetAttribute != null) {
            this.targetAttribute.u2attributesCount = this.deleteAttribute(this.targetAttribute.u2attributesCount, this.targetAttribute.attributes, string);
        } else if (this.targetMember != null) {
            this.targetMember.u2attributesCount = this.deleteAttribute(this.targetMember.u2attributesCount, this.targetMember.attributes, string);
        } else {
            this.targetClass.u2attributesCount = this.deleteAttribute(this.targetClass.u2attributesCount, this.targetClass.attributes, string);
        }
    }

    private boolean replaceAttribute(int n, Attribute[] attributeArray, Attribute attribute) {
        int n2 = this.findAttributeIndex(n, attributeArray, attribute.getAttributeName(this.targetClass));
        if (n2 < 0) {
            return false;
        }
        attributeArray[n2] = attribute;
        return true;
    }

    private Attribute[] addAttribute(int n, Attribute[] attributeArray, Attribute attribute) {
        if (attributeArray.length <= n) {
            Attribute[] attributeArray2 = new Attribute[n + 1];
            System.arraycopy(attributeArray, 0, attributeArray2, 0, n);
            attributeArray = attributeArray2;
        }
        attributeArray[n] = attribute;
        return attributeArray;
    }

    private int deleteAttribute(int n, Attribute[] attributeArray, String string) {
        int n2 = this.findAttributeIndex(n, attributeArray, string);
        if (n2 < 0) {
            return n;
        }
        System.arraycopy(attributeArray, n2 + 1, attributeArray, n2, n - n2 - 1);
        attributeArray[--n] = null;
        return n;
    }

    private int findAttributeIndex(int n, Attribute[] attributeArray, String string) {
        for (int i = 0; i < n; ++i) {
            Attribute attribute = attributeArray[i];
            if (!attribute.getAttributeName(this.targetClass).equals(string)) continue;
            return i;
        }
        return -1;
    }

    private Attribute findAttribute(int n, Attribute[] attributeArray, String string) {
        for (int i = 0; i < n; ++i) {
            Attribute attribute = attributeArray[i];
            if (!attribute.getAttributeName(this.targetClass).equals(string)) continue;
            return attribute;
        }
        return null;
    }
}

