/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.main;

import com.google.auto.value.AutoValue;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.common.io.MoreFiles;
import com.google.turbine.binder.Binder;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.ClassPathBinder;
import com.google.turbine.binder.CtSymClassBinder;
import com.google.turbine.binder.JimageClassBinder;
import com.google.turbine.binder.Processing;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.deps.Dependencies;
import com.google.turbine.deps.Transitive;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.lower.Lower;
import com.google.turbine.main.AutoValue_Main_Result;
import com.google.turbine.main.UsageException;
import com.google.turbine.options.TurbineOptions;
import com.google.turbine.options.TurbineOptionsParser;
import com.google.turbine.parse.Parser;
import com.google.turbine.proto.DepsProto;
import com.google.turbine.proto.ManifestProto;
import com.google.turbine.tree.Tree;
import com.google.turbine.zip.Zip;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class Main {
    private static final int BUFFER_SIZE = 65536;
    static final String MANIFEST_DIR = "META-INF/";
    static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    static final Attributes.Name TARGET_LABEL = new Attributes.Name("Target-Label");
    static final Attributes.Name INJECTING_RULE_KIND = new Attributes.Name("Injecting-Rule-Kind");
    static final long DEFAULT_TIMESTAMP = LocalDateTime.of(2010, 1, 1, 0, 0, 0).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();

    public static void main(String[] args) throws IOException {
        boolean ok;
        try {
            Main.compile(args);
            ok = true;
        }
        catch (TurbineError | UsageException e) {
            System.err.println(e.getMessage());
            ok = false;
        }
        catch (Throwable turbineCrash) {
            turbineCrash.printStackTrace();
            ok = false;
        }
        System.exit(ok ? 0 : 1);
    }

    public static void compile(String[] args) throws IOException {
        Main.compile(TurbineOptionsParser.parse(Arrays.asList(args)));
    }

    public static Result compile(TurbineOptions options) throws IOException {
        Binder.BindingResult bound;
        Main.usage(options);
        ImmutableList<Tree.CompUnit> units = Main.parseAll(options);
        ClassPath bootclasspath = Main.bootclasspath(options);
        TurbineOptions.ReducedClasspathMode reducedClasspathMode = options.reducedClasspathMode();
        if (reducedClasspathMode == TurbineOptions.ReducedClasspathMode.JAVABUILDER_REDUCED && options.directJars().isEmpty()) {
            reducedClasspathMode = TurbineOptions.ReducedClasspathMode.NONE;
        }
        boolean transitiveClasspathFallback = false;
        ImmutableList<String> classPath = options.classPath();
        int transitiveClasspathLength = classPath.size();
        int reducedClasspathLength = classPath.size();
        switch (reducedClasspathMode) {
            case NONE: {
                bound = Main.bind(options, units, bootclasspath, classPath);
                break;
            }
            case BAZEL_FALLBACK: {
                reducedClasspathLength = options.reducedClasspathLength();
                bound = Main.bind(options, units, bootclasspath, classPath);
                transitiveClasspathFallback = true;
                break;
            }
            case JAVABUILDER_REDUCED: {
                Collection<String> reducedClasspath = Dependencies.reduceClasspath(classPath, options.directJars(), options.depsArtifacts());
                reducedClasspathLength = reducedClasspath.size();
                try {
                    bound = Main.bind(options, units, bootclasspath, reducedClasspath);
                }
                catch (TurbineError e) {
                    bound = Main.fallback(options, units, bootclasspath, classPath);
                    transitiveClasspathFallback = true;
                }
                break;
            }
            case BAZEL_REDUCED: {
                transitiveClasspathLength = options.fullClasspathLength();
                try {
                    bound = Main.bind(options, units, bootclasspath, classPath);
                    break;
                }
                catch (TurbineError e) {
                    Main.writeJdepsForFallback(options);
                    return Result.create(true, transitiveClasspathLength, reducedClasspathLength, Binder.Statistics.empty());
                }
            }
            default: {
                throw new AssertionError((Object)reducedClasspathMode);
            }
        }
        if (options.outputDeps().isPresent() || options.output().isPresent() || options.outputManifest().isPresent()) {
            Lower.Lowered lowered = Lower.lowerAll(bound.units(), bound.modules(), bound.classPathEnv());
            if (options.outputDeps().isPresent()) {
                DepsProto.Dependencies deps = Dependencies.collectDeps(options.targetLabel(), bootclasspath, bound, lowered);
                try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get(options.outputDeps().get(), new String[0]), new OpenOption[0]));){
                    deps.writeTo(os);
                }
            }
            if (options.output().isPresent()) {
                ImmutableMap<String, byte[]> transitive = Transitive.collectDeps(bootclasspath, bound);
                Main.writeOutput(options, bound.generatedClasses(), lowered.bytes(), transitive);
            }
            if (options.outputManifest().isPresent()) {
                Main.writeManifestProto(options, bound.units(), bound.generatedSources());
            }
        }
        Main.writeSources(options, bound.generatedSources());
        Main.writeResources(options, bound.generatedClasses());
        return Result.create(transitiveClasspathFallback, transitiveClasspathLength, reducedClasspathLength, bound.statistics());
    }

    private static Binder.BindingResult fallback(TurbineOptions options, ImmutableList<Tree.CompUnit> units, ClassPath bootclasspath, ImmutableList<String> classPath) throws IOException {
        return Main.bind(options, units, bootclasspath, classPath);
    }

    public static void writeJdepsForFallback(TurbineOptions options) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get(options.outputDeps().get(), new String[0]), new OpenOption[0]));){
            DepsProto.Dependencies.newBuilder().setRuleLabel(options.targetLabel().get()).setRequiresReducedClasspathFallback(true).build().writeTo(os);
        }
    }

    private static Binder.BindingResult bind(TurbineOptions options, ImmutableList<Tree.CompUnit> units, ClassPath bootclasspath, Collection<String> classpath) throws IOException {
        return Binder.bind(units, ClassPathBinder.bindClasspath(Main.toPaths(classpath)), Processing.initializeProcessors(options.javacOpts(), options.processorPath(), options.processors(), options.builtinProcessors()), bootclasspath, Optional.empty());
    }

    private static void usage(TurbineOptions options) {
        if (options.help()) {
            throw new UsageException();
        }
        if (!(options.output().isPresent() || options.gensrcOutput().isPresent() || options.resourceOutput().isPresent())) {
            throw new UsageException("at least one of --output, --gensrc_output, or --resource_output is required");
        }
    }

    private static ClassPath bootclasspath(TurbineOptions options) throws IOException {
        if (options.release().isPresent() && options.system().isPresent()) {
            throw new UsageException("expected at most one of --release and --system");
        }
        if (options.release().isPresent()) {
            String release = options.release().get();
            if (release.equals(StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value())) {
                return JimageClassBinder.bindDefault();
            }
            ClassPath bootclasspath = CtSymClassBinder.bind(release);
            if (bootclasspath == null) {
                throw new UsageException("not a supported release: " + release);
            }
            return bootclasspath;
        }
        if (options.system().isPresent()) {
            return JimageClassBinder.bind(options.system().get());
        }
        return ClassPathBinder.bindClasspath(Main.toPaths(options.bootClassPath()));
    }

    private static ImmutableList<Tree.CompUnit> parseAll(TurbineOptions options) throws IOException {
        ImmutableList.Builder units = ImmutableList.builder();
        for (String source : options.sources()) {
            Path path = Paths.get(source, new String[0]);
            units.add((Object)Parser.parse(new SourceFile(source, MoreFiles.asCharSource((Path)path, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]).read())));
        }
        for (String sourceJar : options.sourceJars()) {
            for (Zip.Entry ze : new Zip.ZipIterable(Paths.get(sourceJar, new String[0]))) {
                if (!ze.name().endsWith(".java")) continue;
                String name = ze.name();
                String source = new String(ze.data(), StandardCharsets.UTF_8);
                units.add((Object)Parser.parse(new SourceFile(name, source)));
            }
        }
        return units.build();
    }

    private static void writeSources(TurbineOptions options, ImmutableMap<String, SourceFile> generatedSources) throws IOException {
        if (!options.gensrcOutput().isPresent()) {
            return;
        }
        Path path = Paths.get(options.gensrcOutput().get(), new String[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os, 65536);
             JarOutputStream jos = new JarOutputStream(bos);){
            for (SourceFile source : generatedSources.values()) {
                Main.addEntry(jos, source.path(), source.source().getBytes(StandardCharsets.UTF_8));
            }
            Main.writeManifest(jos, Main.manifest());
        }
    }

    private static void writeResources(TurbineOptions options, ImmutableMap<String, byte[]> generatedResources) throws IOException {
        if (!options.resourceOutput().isPresent()) {
            return;
        }
        Path path = Paths.get(options.resourceOutput().get(), new String[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os, 65536);
             JarOutputStream jos = new JarOutputStream(bos);){
            for (Map.Entry resource : generatedResources.entrySet()) {
                Main.addEntry(jos, (String)resource.getKey(), (byte[])resource.getValue());
            }
        }
    }

    private static void writeOutput(TurbineOptions options, Map<String, byte[]> generated, Map<String, byte[]> lowered, Map<String, byte[]> transitive) throws IOException {
        Path path = Paths.get(options.output().get(), new String[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os, 65536);
             JarOutputStream jos = new JarOutputStream(bos);){
            for (Map.Entry<String, byte[]> entry : lowered.entrySet()) {
                Main.addEntry(jos, entry.getKey() + ".class", entry.getValue());
            }
            for (Map.Entry<String, byte[]> entry : generated.entrySet()) {
                Main.addEntry(jos, entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, byte[]> entry : transitive.entrySet()) {
                Main.addEntry(jos, "META-INF/TRANSITIVE/" + entry.getKey() + ".class", entry.getValue());
            }
            if (options.targetLabel().isPresent()) {
                Main.writeManifest(jos, Main.manifest(options));
            }
        }
    }

    private static void writeManifestProto(TurbineOptions options, ImmutableMap<ClassSymbol, SourceTypeBoundClass> units, ImmutableMap<String, SourceFile> generatedSources) throws IOException {
        ManifestProto.Manifest.Builder manifest = ManifestProto.Manifest.newBuilder();
        for (Map.Entry e : units.entrySet()) {
            manifest.addCompilationUnit(ManifestProto.CompilationUnit.newBuilder().setPath(((SourceTypeBoundClass)e.getValue()).source().path()).setPkg(((ClassSymbol)e.getKey()).packageName()).addTopLevel(((ClassSymbol)e.getKey()).simpleName()).setGeneratedByAnnotationProcessor(generatedSources.containsKey((Object)((SourceTypeBoundClass)e.getValue()).source().path())).build());
        }
        try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(Paths.get(options.outputManifest().get(), new String[0]), new OpenOption[0]));){
            manifest.build().writeTo(os);
        }
    }

    private static void addEntry(JarOutputStream jos, String name, byte[] bytes) throws IOException {
        JarEntry je = new JarEntry(name);
        je.setTime(DEFAULT_TIMESTAMP);
        je.setMethod(0);
        je.setSize(bytes.length);
        je.setCrc(Hashing.crc32().hashBytes(bytes).padToLong());
        jos.putNextEntry(je);
        jos.write(bytes);
    }

    private static void writeManifest(JarOutputStream jos, Manifest manifest) throws IOException {
        Main.addEntry(jos, MANIFEST_DIR, new byte[0]);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        manifest.write(out);
        Main.addEntry(jos, MANIFEST_NAME, out.toByteArray());
    }

    private static Manifest manifest() {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        Attributes.Name createdBy = new Attributes.Name("Created-By");
        if (attributes.getValue(createdBy) == null) {
            attributes.put(createdBy, "bazel");
        }
        return manifest;
    }

    private static Manifest manifest(TurbineOptions turbineOptions) {
        Manifest manifest = Main.manifest();
        Attributes attributes = manifest.getMainAttributes();
        if (turbineOptions.targetLabel().isPresent()) {
            attributes.put(TARGET_LABEL, turbineOptions.targetLabel().get());
        }
        if (turbineOptions.injectingRuleKind().isPresent()) {
            attributes.put(INJECTING_RULE_KIND, turbineOptions.injectingRuleKind().get());
        }
        return manifest;
    }

    private static ImmutableList<Path> toPaths(Iterable<String> paths) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String path : paths) {
            result.add((Object)Paths.get(path, new String[0]));
        }
        return result.build();
    }

    @AutoValue
    public static abstract class Result {
        public abstract boolean transitiveClasspathFallback();

        public abstract int transitiveClasspathLength();

        public abstract int reducedClasspathLength();

        public abstract Binder.Statistics processorStatistics();

        static Result create(boolean transitiveClasspathFallback, int transitiveClasspathLength, int reducedClasspathLength, Binder.Statistics processorStatistics) {
            return new AutoValue_Main_Result(transitiveClasspathFallback, transitiveClasspathLength, reducedClasspathLength, processorStatistics);
        }
    }
}

