/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;

@BugPattern(name="ComparingThisWithNull", summary="this == null is always false, this != null is always true", explanation="The boolean expression this != null always returns true and similarly this == null always returns false.", severity=BugPattern.SeverityLevel.ERROR)
public class ComparingThisWithNull
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final Matcher<BinaryTree> EQUAL_OR_NOT_EQUAL = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.EQUAL_TO), Matchers.kindIs((Tree.Kind)Tree.Kind.NOT_EQUAL_TO)}), Matchers.binaryTree((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.NULL_LITERAL), (Matcher)new ThisMatcher())});

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (EQUAL_OR_NOT_EQUAL.matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static class ThisMatcher
    implements Matcher<ExpressionTree> {
        private ThisMatcher() {
        }

        public boolean matches(ExpressionTree thisExpression, VisitorState state) {
            IdentifierTree identifier;
            return thisExpression.getKind().equals((Object)Tree.Kind.IDENTIFIER) && (identifier = (IdentifierTree)thisExpression).getName().contentEquals("this");
        }
    }
}

