/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.util;

import java.util.HashSet;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.util.AbstractMostlySingleton;
import org.checkerframework.shaded.javacutil.BugInCF;

public final class MostlySingleton<T>
extends AbstractMostlySingleton<T> {
    public MostlySingleton() {
        super(AbstractMostlySingleton.State.EMPTY);
    }

    public MostlySingleton(T value) {
        super(AbstractMostlySingleton.State.SINGLETON, value);
    }

    @Override
    public boolean add(T e) {
        switch (this.state) {
            case EMPTY: {
                this.state = AbstractMostlySingleton.State.SINGLETON;
                this.value = e;
                return true;
            }
            case SINGLETON: {
                this.state = AbstractMostlySingleton.State.ANY;
                this.set = new HashSet();
                assert (this.value != null) : "@AssumeAssertion(nullness): previous add is non-null";
                this.set.add(this.value);
                this.value = null;
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.add(e);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }

    @Override
    public boolean contains(@Nullable Object o) {
        switch (this.state) {
            case EMPTY: {
                return false;
            }
            case SINGLETON: {
                return Objects.equals(o, this.value);
            }
            case ANY: {
                assert (this.set != null) : "@AssumeAssertion(nullness): set initialized before";
                return this.set.contains(o);
            }
        }
        throw new BugInCF("Unhandled state " + (Object)((Object)this.state));
    }
}

