/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

class ServiceLoaderUtil {
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "org.glassfish.hk2.osgiresourcelocator.ServiceLoader";
    private static final String OSGI_SERVICE_LOADER_METHOD_NAME = "lookupProviderClasses";

    ServiceLoaderUtil() {
    }

    static <P, T extends Exception> P firstByServiceLoader(Class<P> clazz, Logger logger, ExceptionHandler<T> exceptionHandler) throws T {
        try {
            ServiceLoader<P> serviceLoader = ServiceLoader.load(clazz);
            Iterator<P> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                P p = iterator.next();
                logger.fine("ServiceProvider loading Facility used; returning object [" + p.getClass().getName() + "]");
                return p;
            }
        }
        catch (Throwable throwable) {
            throw exceptionHandler.createException(throwable, "Error while searching for service [" + clazz.getName() + "]");
        }
        return null;
    }

    static Object lookupUsingOSGiServiceLoader(String string, Logger logger) {
        try {
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            Method method = clazz2.getMethod(OSGI_SERVICE_LOADER_METHOD_NAME, Class.class);
            Iterator iterator = ((Iterable)method.invoke(null, clazz)).iterator();
            if (iterator.hasNext()) {
                Object t = iterator.next();
                logger.fine("Found implementation using OSGi facility; returning object [" + t.getClass().getName() + "].");
                return t;
            }
            return null;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            logger.log(Level.FINE, "Unable to find from OSGi: [" + string + "]", reflectiveOperationException);
            return null;
        }
    }

    static void checkPackageAccess(String string) {
        int n;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
            securityManager.checkPackageAccess(string.substring(0, n));
        }
    }

    static Class nullSafeLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            return Class.forName(string);
        }
        return classLoader.loadClass(string);
    }

    static <T extends Exception> Object newInstance(String string, String string2, ExceptionHandler<T> exceptionHandler) throws T {
        try {
            return ServiceLoaderUtil.safeLoadClass(string, string2, ServiceLoaderUtil.contextClassLoader(exceptionHandler)).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw exceptionHandler.createException(classNotFoundException, "Provider " + string + " not found");
        }
        catch (Exception exception) {
            throw exceptionHandler.createException(exception, "Provider " + string + " could not be instantiated: " + exception);
        }
    }

    static Class safeLoadClass(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            ServiceLoaderUtil.checkPackageAccess(string);
        }
        catch (SecurityException securityException) {
            if (string2 != null && string2.equals(string)) {
                return Class.forName(string);
            }
            throw securityException;
        }
        return ServiceLoaderUtil.nullSafeLoadClass(string, classLoader);
    }

    static ClassLoader contextClassLoader(ExceptionHandler exceptionHandler) throws Exception {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            throw exceptionHandler.createException(exception, exception.toString());
        }
    }

    static abstract class ExceptionHandler<T extends Exception> {
        ExceptionHandler() {
        }

        public abstract T createException(Throwable var1, String var2);
    }
}

