/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.function.Function;
import java.util.stream.Collectors;

@BugPattern(name="MultipleUnaryOperatorsInMethodCall", summary="Avoid having multiple unary operators acting on the same variable in a method call", severity=BugPattern.SeverityLevel.WARNING)
public class MultipleUnaryOperatorsInMethodCall
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<Tree.Kind> UNARY_OPERATORS = Sets.immutableEnumSet((Enum)Tree.Kind.POSTFIX_DECREMENT, (Enum[])new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT});

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState visitorState) {
        if (methodInvocationTree.getArguments().stream().filter(arg -> UNARY_OPERATORS.contains((Object)arg.getKind())).map(arg -> ASTHelpers.getSymbol((Tree)((UnaryTree)arg).getExpression())).filter(sym -> sym != null).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().anyMatch(e -> (Long)e.getValue() > 1L)) {
            return this.describeMatch(methodInvocationTree);
        }
        return Description.NO_MATCH;
    }
}

