/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.fixes.SuggestedFix;

public class BranchedSuggestedFixes {
    private final ImmutableList<SuggestedFix> fixes;

    private BranchedSuggestedFixes(ImmutableList<SuggestedFix> fixes) {
        this.fixes = fixes;
    }

    public ImmutableList<SuggestedFix> getFixes() {
        return this.fixes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ImmutableList.Builder<SuggestedFix> builder = ImmutableList.builder();
        private ImmutableList<SuggestedFix> savedList = ImmutableList.of();

        public Builder startWith(SuggestedFix fix) {
            this.savedList = ImmutableList.of();
            this.builder = ImmutableList.builder().add((Object)fix);
            return this;
        }

        public Builder addOption(SuggestedFix fix) {
            if (!this.savedList.isEmpty()) {
                for (SuggestedFix s : this.savedList) {
                    this.builder.add((Object)SuggestedFix.builder().merge(s).merge(fix).build());
                }
            }
            return this;
        }

        public Builder then() {
            this.savedList = this.builder.build();
            this.builder = ImmutableList.builder();
            return this;
        }

        public BranchedSuggestedFixes build() {
            return new BranchedSuggestedFixes((ImmutableList<SuggestedFix>)this.builder.build());
        }
    }
}

