/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="Optional.of() always returns a non-empty optional. Using ifPresent/isPresent/orElse/orElseGet/orElseThrow/isPresent/or/orNull method on it is unnecessary and most probably a bug.", severity=BugPattern.SeverityLevel.ERROR)
public class OptionalOfRedundantMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GUAVA_OPTIONAL_OF_MATCHER = Matchers.staticMethod().onClass("com.google.common.base.Optional").named("of");
    private static final Matcher<ExpressionTree> OPTIONAL_OF_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.Optional").named("of"), GUAVA_OPTIONAL_OF_MATCHER});
    private static final Matcher<ExpressionTree> REDUNDANT_METHOD_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onExactClass("java.util.Optional").namedAnyOf(new String[]{"ifPresent", "isPresent", "orElse", "orElseGet", "orElseThrow"}), Matchers.instanceMethod().onExactClass("com.google.common.base.Optional").namedAnyOf(new String[]{"isPresent", "or", "orNull"})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree childMethodInvocationTree = ASTHelpers.getReceiver((ExpressionTree)tree);
        if (!(childMethodInvocationTree instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        if (!OPTIONAL_OF_MATCHER.matches((Tree)childMethodInvocationTree, state) || !REDUNDANT_METHOD_MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String methodName = ((Name)ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName()).toString();
        return this.buildDescription(tree).setMessage(String.format("Optional.of() always returns a non-empty Optional. Using '%s' method on it is unnecessary and most probably a bug.", methodName)).addAllFixes(this.getSuggestedFixes(tree, state)).build();
    }

    private ImmutableList<SuggestedFix> getSuggestedFixes(MethodInvocationTree tree, VisitorState state) {
        MethodInvocationTree optionalOfInvocationTree = (MethodInvocationTree)ASTHelpers.getReceiver((ExpressionTree)tree);
        String nullableMethodName = GUAVA_OPTIONAL_OF_MATCHER.matches((Tree)optionalOfInvocationTree, state) ? "fromNullable" : "ofNullable";
        ImmutableList.Builder fixesBuilder = ImmutableList.builder();
        fixesBuilder.add((Object)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)optionalOfInvocationTree, (String)nullableMethodName, (VisitorState)state));
        if (state.getPath().getParentPath().getLeaf() instanceof ExpressionStatementTree) {
            return fixesBuilder.build();
        }
        javax.lang.model.element.Name methodSimpleName = ASTHelpers.getSymbol((MethodInvocationTree)tree).getSimpleName();
        if (((Name)methodSimpleName).contentEquals("orElse") || ((Name)methodSimpleName).contentEquals("orElseGet") || ((Name)methodSimpleName).contentEquals("orElseThrow") || ((Name)methodSimpleName).contentEquals("or") || ((Name)methodSimpleName).contentEquals("orNull")) {
            Tree argument = optionalOfInvocationTree.getArguments().get(0);
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder().replace((Tree)tree, state.getSourceForNode(argument));
            fixBuilder.setShortDescription("Simplify expression.");
            if (((Name)methodSimpleName).contentEquals("orElse")) {
                fixBuilder.setShortDescription("Simplify expression. Note that this may change semantics if arguments have side effects");
            }
            fixesBuilder.add((Object)fixBuilder.build());
        } else if (((Name)methodSimpleName).contentEquals("isPresent")) {
            fixesBuilder.add((Object)SuggestedFix.builder().replace((Tree)tree, "true").build());
        }
        return fixesBuilder.build();
    }
}

