/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.refaster.AutoValue_UOfKind;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import java.util.Set;
import javax.annotation.Nullable;

@AutoValue
abstract class UOfKind
extends UExpression {
    UOfKind() {
    }

    public static UOfKind create(UExpression expression, Set<Tree.Kind> allowed) {
        return new AutoValue_UOfKind(expression, (ImmutableSet<Tree.Kind>)ImmutableSet.copyOf(allowed));
    }

    abstract UExpression expression();

    abstract ImmutableSet<Tree.Kind> allowed();

    @Override
    public JCTree.JCExpression inline(Inliner inliner) throws CouldNotResolveImportException {
        return (JCTree.JCExpression)this.expression().inline(inliner);
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return this.expression().accept(visitor, data);
    }

    @Override
    public Tree.Kind getKind() {
        return this.expression().getKind();
    }

    @Override
    @Nullable
    protected Choice<Unifier> defaultAction(Tree tree, @Nullable Unifier unifier) {
        return Choice.condition(this.allowed().contains((Object)tree.getKind()), unifier).thenChoose(Unifier.unifications(this.expression(), tree));
    }
}

