/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.AssetRepository;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.ide.common.rendering.api.IImageFactory;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.resources.Density;
import com.android.resources.ScreenSize;
import java.util.HashMap;
import java.util.Map;

public abstract class RenderParams {
    public static final long DEFAULT_TIMEOUT = 250L;
    private final Object mProjectKey;
    private final HardwareConfig mHardwareConfig;
    private final RenderResources mRenderResources;
    private final LayoutlibCallback mLayoutlibCallback;
    private final int mMinSdkVersion;
    private final int mTargetSdkVersion;
    private final LayoutLog mLog;
    private boolean mCustomBackgroundEnabled;
    private int mCustomBackgroundColor;
    private long mTimeout;
    private AssetRepository mAssetRepository;
    private IImageFactory mImageFactory;
    private String mAppIcon;
    private String mAppLabel;
    private String mLocale;
    private String mActivityName;
    private boolean mForceNoDecor;
    private boolean mSupportsRtl;
    private Map<SessionParams.Key, Object> mFlags;

    public RenderParams(Object projectKey, HardwareConfig hardwareConfig, RenderResources renderResources, LayoutlibCallback layoutlibCallback, int minSdkVersion, int targetSdkVersion, LayoutLog log) {
        this.mProjectKey = projectKey;
        this.mHardwareConfig = hardwareConfig;
        this.mRenderResources = renderResources;
        this.mLayoutlibCallback = layoutlibCallback;
        this.mMinSdkVersion = minSdkVersion;
        this.mTargetSdkVersion = targetSdkVersion;
        this.mLog = log;
        this.mCustomBackgroundEnabled = false;
        this.mTimeout = 250L;
    }

    public RenderParams(RenderParams params) {
        this.mProjectKey = params.mProjectKey;
        this.mHardwareConfig = params.mHardwareConfig;
        this.mRenderResources = params.mRenderResources;
        this.mAssetRepository = params.mAssetRepository;
        this.mLayoutlibCallback = params.mLayoutlibCallback;
        this.mMinSdkVersion = params.mMinSdkVersion;
        this.mTargetSdkVersion = params.mTargetSdkVersion;
        this.mLog = params.mLog;
        this.mCustomBackgroundEnabled = params.mCustomBackgroundEnabled;
        this.mCustomBackgroundColor = params.mCustomBackgroundColor;
        this.mTimeout = params.mTimeout;
        this.mImageFactory = params.mImageFactory;
        this.mAppIcon = params.mAppIcon;
        this.mAppLabel = params.mAppLabel;
        this.mLocale = params.mLocale;
        this.mActivityName = params.mActivityName;
        this.mForceNoDecor = params.mForceNoDecor;
        this.mSupportsRtl = params.mSupportsRtl;
        if (params.mFlags != null) {
            this.mFlags = new HashMap<SessionParams.Key, Object>(params.mFlags);
        }
    }

    public void setOverrideBgColor(int color) {
        this.mCustomBackgroundEnabled = true;
        this.mCustomBackgroundColor = color;
    }

    public void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    public void setImageFactory(IImageFactory imageFactory) {
        this.mImageFactory = imageFactory;
    }

    public void setAppIcon(String appIcon) {
        this.mAppIcon = appIcon;
    }

    public void setAppLabel(String appLabel) {
        this.mAppLabel = appLabel;
    }

    public void setLocale(String locale) {
        this.mLocale = locale;
    }

    public void setActivityName(String activityName) {
        this.mActivityName = activityName;
    }

    public void setForceNoDecor() {
        this.mForceNoDecor = true;
    }

    public void setRtlSupport(boolean supportsRtl) {
        this.mSupportsRtl = supportsRtl;
    }

    public void setAssetRepository(AssetRepository assetRepository) {
        this.mAssetRepository = assetRepository;
    }

    public Object getProjectKey() {
        return this.mProjectKey;
    }

    public HardwareConfig getHardwareConfig() {
        return this.mHardwareConfig;
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    @Deprecated
    public int getScreenWidth() {
        return this.mHardwareConfig.getScreenWidth();
    }

    @Deprecated
    public int getScreenHeight() {
        return this.mHardwareConfig.getScreenHeight();
    }

    @Deprecated
    public Density getDensity() {
        return this.mHardwareConfig.getDensity();
    }

    @Deprecated
    public float getXdpi() {
        return this.mHardwareConfig.getXdpi();
    }

    @Deprecated
    public float getYdpi() {
        return this.mHardwareConfig.getYdpi();
    }

    public RenderResources getResources() {
        return this.mRenderResources;
    }

    public AssetRepository getAssets() {
        return this.mAssetRepository;
    }

    @Deprecated
    public IProjectCallback getProjectCallback() {
        return this.getLayoutlibCallback();
    }

    public LayoutlibCallback getLayoutlibCallback() {
        return this.mLayoutlibCallback;
    }

    public LayoutLog getLog() {
        return this.mLog;
    }

    public boolean isBgColorOverridden() {
        return this.mCustomBackgroundEnabled;
    }

    public int getOverrideBgColor() {
        return this.mCustomBackgroundColor;
    }

    public long getTimeout() {
        return this.mTimeout;
    }

    public IImageFactory getImageFactory() {
        return this.mImageFactory;
    }

    @Deprecated
    public ScreenSize getConfigScreenSize() {
        return this.mHardwareConfig.getScreenSize();
    }

    public String getAppIcon() {
        return this.mAppIcon;
    }

    public String getAppLabel() {
        return this.mAppLabel;
    }

    public String getLocale() {
        return this.mLocale;
    }

    public String getActivityName() {
        return this.mActivityName;
    }

    public boolean isForceNoDecor() {
        return this.mForceNoDecor;
    }

    public boolean isRtlSupported() {
        return this.mSupportsRtl;
    }

    public <T> void setFlag(SessionParams.Key<T> key, T value) {
        if (this.mFlags == null) {
            this.mFlags = new HashMap<SessionParams.Key, Object>();
        }
        this.mFlags.put(key, value);
    }

    public <T> T getFlag(SessionParams.Key<T> key) {
        return (T)(this.mFlags == null ? null : this.mFlags.get(key));
    }
}

