/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.block;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.cfg.block.Block;
import org.checkerframework.errorprone.dataflow.cfg.block.BlockImpl;
import org.checkerframework.errorprone.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.errorprone.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.javacutil.BugInCF;

public class ExceptionBlockImpl
extends SingleSuccessorBlockImpl
implements ExceptionBlock {
    protected @Nullable Node node;
    protected final Map<TypeMirror, Set<Block>> exceptionalSuccessors = new LinkedHashMap<TypeMirror, Set<Block>>(2);

    public ExceptionBlockImpl() {
        super(Block.BlockType.EXCEPTION_BLOCK);
    }

    public void setNode(Node c) {
        this.node = c;
        c.setBlock(this);
    }

    @Override
    public Node getNode() {
        if (this.node == null) {
            throw new BugInCF("Requested node for exception block before initialization");
        }
        return this.node;
    }

    @Override
    public List<Node> getNodes() {
        return Collections.singletonList(this.getNode());
    }

    @Override
    public @Nullable Node getLastNode() {
        return null;
    }

    public void addExceptionalSuccessor(BlockImpl b, TypeMirror cause) {
        Set blocks = this.exceptionalSuccessors.computeIfAbsent(cause, __ -> new LinkedHashSet());
        blocks.add(b);
        b.addPredecessor(this);
    }

    @Override
    public Map<TypeMirror, Set<Block>> getExceptionalSuccessors() {
        if (this.exceptionalSuccessors == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.exceptionalSuccessors);
    }

    @Override
    public Set<Block> getSuccessors() {
        LinkedHashSet<Block> result = new LinkedHashSet<Block>(super.getSuccessors());
        for (Set<Block> blocks : this.getExceptionalSuccessors().values()) {
            result.addAll(blocks);
        }
        return result;
    }

    public String toString() {
        return "ExceptionBlock(" + this.node + ")";
    }
}

