/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="The result of CacheLoader#load must be non-null.", severity=BugPattern.SeverityLevel.WARNING)
public class CacheLoaderNull
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Supplier<Type> CACHE_LOADER_TYPE = Suppliers.typeFromString((String)"com.google.common.cache.CacheLoader");

    public Description matchMethod(MethodTree tree, final VisitorState state) {
        if (!tree.getName().contentEquals("load")) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)tree);
        if (!ASTHelpers.isSubtype((Type)sym.owner.asType(), (Type)((Type)CACHE_LOADER_TYPE.get(state)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitLambdaExpression(LambdaExpressionTree tree, Void unused) {
                return null;
            }

            @Override
            public Void visitClass(ClassTree tree, Void unused) {
                return null;
            }

            @Override
            public Void visitReturn(ReturnTree tree, Void unused) {
                ExpressionTree expression = tree.getExpression();
                if (expression != null && expression.getKind() == Tree.Kind.NULL_LITERAL) {
                    state.reportMatch(CacheLoaderNull.this.describeMatch(tree));
                }
                return (Void)super.visitReturn(tree, null);
            }
        }.scan(tree.getBody(), null);
        return Description.NO_MATCH;
    }
}

