/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inlineme;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inlineme.InlinabilityResult;
import com.google.errorprone.bugpatterns.inlineme.InlineMeData;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;

@BugPattern(name="InlineMeSuggester", summary="This deprecated API looks inlineable. If you'd like the body of the API to be automatically inlined to its callers, please annotate it with @InlineMe. NOTE: the suggested fix makes the method final if it was not already.", severity=BugPattern.SeverityLevel.WARNING)
public final class Suggester
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String INLINE_ME = "com.google.errorprone.annotations.InlineMe";

    @Inject
    Suggester() {
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!ASTHelpers.hasAnnotation((Tree)tree, Deprecated.class, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasDirectAnnotationWithSimpleName((Tree)tree, (String)"InlineMe")) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)tree, DoNotCall.class, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.shouldKeep((Tree)tree) || InjectMatchers.hasProvidesAnnotation().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        InlinabilityResult inlinabilityResult = InlinabilityResult.forMethod(tree, state);
        if (!inlinabilityResult.isValidForSuggester()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder().addImport(INLINE_ME).prefixWith((Tree)tree, InlineMeData.buildExpectedInlineMeAnnotation(state, inlinabilityResult.body()).buildAnnotation());
        if (inlinabilityResult.error() == InlinabilityResult.InlineValidationErrorReason.METHOD_CAN_BE_OVERIDDEN_BUT_CAN_BE_FIXED) {
            SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fixBuilder).merge(arg_0));
        }
        return this.describeMatch(tree, (Fix)fixBuilder.build());
    }
}

