/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.swing;

import ccl.util.Util;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;

/**
 * This window displays an animated icon to show its app
 * is busy while the user has to wait for something to
 * finish.
 *
 * Usage: BusyWindow.start();<br>
 *        BusyWindow.stop();
 *
 * @version  $Id: BusyWindow.java,v 1.4 2002/10/06 16:41:26 clemens Exp clemens $
 * @author   <a href="http://www.kclee.com/clemens/">
 *           Chr. Clemens Lee</a>
 *           &lt;<a href="mailto:clemens@kclee.com">
 *           clemens@kclee.com
 *           </a>>
 */
public class BusyWindow extends CCLBorderWindow 
{
    private AnimationPanel _pAnimationCanvas = null;
    private static BusyWindow _pBusyWindow = null;

    protected BusyWindow(Frame frmParent_) 
    {
        super(frmParent_);

        Image pImage = Toolkit.getDefaultToolkit().
               getImage( this.getClass().getResource
                         ( "anim_recycle_brown.gif" ) );
        _pAnimationCanvas = new AnimationPanel( pImage,
                                                350 );
        add("Center", _pAnimationCanvas);
        Dimension dimAnim = _pAnimationCanvas.getPreferredSize();
        _pAnimationCanvas.setSize(dimAnim);

        setSize(getPreferredSize());

        show();
        setVisible(false); // ?? old workaround or dead code?
        setSize(getPreferredSize()); // ??
    }

    public Dimension getPreferredSize() 
    {
        Insets insThis = getInsets();
        Dimension dimRetVal = _pAnimationCanvas.getPreferredSize();
        dimRetVal.width += insThis.left + insThis.right;
        dimRetVal.height += insThis.top + insThis.bottom;

        return dimRetVal;
    }

    private static int _oldThreadPriority = Thread.currentThread()
                                                  .getPriority  ();

    public static void start(Frame frmParent_) 
    {
        Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
        if (_pBusyWindow == null) 
        {
            _pBusyWindow = new BusyWindow(frmParent_);
        }
        SwingUtil.centerComponent( _pBusyWindow, frmParent_, 3 );
        _pBusyWindow._pAnimationCanvas.start();
        _pBusyWindow.setVisible(true);
        Util.debug( "ccl.swing.BusyWindow.start(..)._pBusyWindow.getSize(): " 
                      + _pBusyWindow.getSize() );
    }

    public static void stop() 
    {
        if ( _pBusyWindow.isVisible() ) 
        {
            Thread.currentThread().setPriority(_oldThreadPriority);
            _pBusyWindow.setVisible(false);
            _pBusyWindow._pAnimationCanvas.stop();
        }
    }
}
