/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the reusable ccl java library
 * (http://www.kclee.com/clemens/java/ccl/).
 *
 * The Initial Developer of the Original Code is
 * Chr. Clemens Lee.
 * Portions created by Chr. Clemens Lee are Copyright (C) 2002
 * Chr. Clemens Lee. All Rights Reserved.
 *
 * Contributor(s): Chr. Clemens Lee <clemens@kclee.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package ccl.util.test;

import ccl.util.FileUtil;
import ccl.util.IniFile;
import ccl.util.Test;
import ccl.util.Util;
import java.io.FileOutputStream;
import java.io.InputStream;

/**
 * Tests for ccl.util.IniFile.
 *
 * @version $Id: IniFileTest.java,v 1.10 2003/05/01 16:44:47 clemens Exp clemens $
 * @author <a href="http://www.kclee.com/clemens/">
 *         Chr. Clemens Lee</a>
 *         &lt;<a href="mailto:clemens@kclee.com">
 *         clemens@kclee.com
 *         </a>>
 */
public class IniFileTest extends Test 
{
    public IniFileTest() 
    {
        super();
    }

    public IniFileTest(Test pTest_) 
    {
        super(pTest_);
    }

    protected void _doIt() 
    {
        InputStream isIniFile = FileUtil.getResourceAsStream
               ( this, "default.ini" );
        bugIf( isIniFile == null, "isIniFile is null!" );
                
        String sTempFile = FileUtil.getTempFileName();
        try 
        {
            FileUtil.copy( isIniFile, new FileOutputStream( sTempFile ) );
            bugIf( false );
        }
        catch( Exception pException ) 
        {
            bugIf( true, "pException: " + pException );
        }

        //String sIniFile = FileUtil.concatPath(sLocalPath, "default.ini");
        String sKeyValue = IniFile.getKeyValue( sTempFile, "Colors", "Background" );
        bugIf( Util.isEmpty(sKeyValue) );
        bugIf( IniFile.getStatus() != IniFile.OK );

        FileUtil.delete( sTempFile );
    }
    
    public static void main(String[] args) 
    {
        Test pTest = (Test) (new IniFileTest());
        Test.printResult(pTest);
    }
}
