/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.dom;

import java.util.ArrayList;
import java.util.List;
import org.outerj.daisy.diff.html.dom.TagNode;
import org.outerj.daisy.diff.html.dom.helper.LastCommonParentResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    protected TagNode parent;
    private boolean whiteBefore = false;
    private boolean whiteAfter = false;

    public Node(TagNode tagNode) {
        this.parent = tagNode;
        if (tagNode != null) {
            tagNode.addChild(this);
        }
    }

    public TagNode getParent() {
        return this.parent;
    }

    public List<TagNode> getParentTree() {
        ArrayList<TagNode> arrayList = new ArrayList<TagNode>(5);
        if (this.getParent() != null) {
            arrayList.addAll(this.getParent().getParentTree());
            arrayList.add(this.getParent());
        }
        return arrayList;
    }

    public TagNode getRoot() {
        TagNode tagNode = this.getParent();
        if (tagNode != null) {
            return tagNode.getRoot();
        }
        if (this instanceof TagNode) {
            return (TagNode)this;
        }
        return null;
    }

    public abstract List<Node> getMinimalDeletedSet(long var1);

    public void detectIgnorableWhiteSpace() {
    }

    public LastCommonParentResult getLastCommonParent(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("The given TextNode is null");
        }
        LastCommonParentResult lastCommonParentResult = new LastCommonParentResult();
        List<TagNode> list = this.getParentTree();
        List<TagNode> list2 = node.getParentTree();
        int n = 1;
        boolean bl = true;
        while (bl && n < list.size() && n < list2.size()) {
            if (!list.get(n).isSameTag(list2.get(n))) {
                bl = false;
                continue;
            }
            ++n;
        }
        lastCommonParentResult.setLastCommonParentDepth(n - 1);
        lastCommonParentResult.setLastCommonParent(list.get(n - 1));
        if (!bl) {
            lastCommonParentResult.setIndexInLastCommonParent(list.get(n - 1).getIndexOf(list.get(n)));
            lastCommonParentResult.setSplittingNeeded();
        } else if (list.size() < list2.size()) {
            lastCommonParentResult.setIndexInLastCommonParent(list.get(n - 1).getIndexOf(this));
        } else if (list.size() > list2.size()) {
            lastCommonParentResult.setIndexInLastCommonParent(list.get(n - 1).getIndexOf(list.get(n)));
            lastCommonParentResult.setSplittingNeeded();
        } else {
            lastCommonParentResult.setIndexInLastCommonParent(list.get(n - 1).getIndexOf(this));
        }
        return lastCommonParentResult;
    }

    public void setParent(TagNode tagNode) {
        this.parent = tagNode;
    }

    public abstract Node copyTree();

    public boolean inPre() {
        for (TagNode tagNode : this.getParentTree()) {
            if (!tagNode.isPre()) continue;
            return true;
        }
        return false;
    }

    public boolean isWhiteBefore() {
        return this.whiteBefore;
    }

    public void setWhiteBefore(boolean bl) {
        this.whiteBefore = bl;
    }

    public boolean isWhiteAfter() {
        return this.whiteAfter;
    }

    public void setWhiteAfter(boolean bl) {
        this.whiteAfter = bl;
    }

    public abstract Node getLeftMostChild();

    public abstract Node getRightMostChild();
}

