/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.ancestor;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.outerj.daisy.diff.html.ancestor.AncestorComparator;
import org.outerj.daisy.diff.html.ancestor.ChangeText;
import org.outerj.daisy.diff.html.ancestor.tagtostring.TagToString;
import org.outerj.daisy.diff.html.ancestor.tagtostring.TagToStringFactory;
import org.outerj.daisy.diff.html.dom.TagNode;
import org.outerj.daisy.diff.html.modification.HtmlLayoutChange;

public class ChangeTextGenerator {
    private List<HtmlLayoutChange> htmlLayoutChanges = null;
    private AncestorComparator ancestorComparator;
    private AncestorComparator other;
    private TagToStringFactory factory;
    private Locale locale;
    private static final int MAX_OUTPUT_LINE_LENGTH = 55;

    public ChangeTextGenerator(AncestorComparator ancestorComparator, AncestorComparator ancestorComparator2, Locale locale) {
        this.ancestorComparator = ancestorComparator;
        this.other = ancestorComparator2;
        this.factory = new TagToStringFactory();
        this.locale = locale;
        this.htmlLayoutChanges = new ArrayList<HtmlLayoutChange>();
    }

    public ChangeText getChanged(RangeDifference ... rangeDifferenceArray) {
        ChangeText changeText = new ChangeText(55);
        boolean bl = false;
        if (rangeDifferenceArray.length > 1) {
            changeText.addHtml("<ul class='changelist'>");
            bl = true;
        }
        for (int i = 0; i < rangeDifferenceArray.length; ++i) {
            int n;
            RangeDifference rangeDifference = rangeDifferenceArray[i];
            boolean bl2 = false;
            if (bl) {
                changeText.addHtml("<li>");
            }
            if (rangeDifference.leftLength() + rangeDifference.rightLength() > 1) {
                changeText.addHtml("<ul class='changelist'>");
                bl2 = true;
            }
            for (n = rangeDifference.leftStart(); n < rangeDifference.leftEnd(); ++n) {
                if (bl2) {
                    changeText.addHtml("<li>");
                }
                this.addTagOld(changeText, this.other.getAncestor(n));
                if (!bl2) continue;
                changeText.addHtml("</li>");
            }
            for (n = rangeDifference.rightStart(); n < rangeDifference.rightEnd(); ++n) {
                if (bl2) {
                    changeText.addHtml("<li>");
                }
                this.addTagNew(changeText, this.getAncestor(n));
                if (!bl2) continue;
                changeText.addHtml("</li>");
            }
            if (bl2) {
                changeText.addHtml("</ul>");
            }
            if (!bl) continue;
            changeText.addHtml("</li>");
        }
        if (bl) {
            changeText.addHtml("</ul>");
        }
        return changeText;
    }

    private void addTagOld(ChangeText changeText, TagNode tagNode) {
        TagToString tagToString = this.factory.create(tagNode, this.locale);
        tagToString.getRemovedDescription(changeText);
        this.htmlLayoutChanges.add(tagToString.getHtmlLayoutChange());
    }

    private void addTagNew(ChangeText changeText, TagNode tagNode) {
        TagToString tagToString = this.factory.create(tagNode, this.locale);
        tagToString.getAddedDescription(changeText);
        this.htmlLayoutChanges.add(tagToString.getHtmlLayoutChange());
    }

    private TagNode getAncestor(int n) {
        return this.ancestorComparator.getAncestor(n);
    }

    public List<HtmlLayoutChange> getHtmlLayoutChanges() {
        return this.htmlLayoutChanges;
    }
}

