/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Transformer;

public class LazyMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, V> map;
    private Transformer factory;

    public LazyMap(Map<K, V> map, Transformer factor) {
        this.map = map;
        this.factory = factor;
    }

    public static <K, V> Map<K, V> decorate(Map<K, V> map, Transformer factory) {
        return new LazyMap<K, V>(map, factory);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        if (!this.map.containsKey(key)) {
            Object value = this.factory.transform(key);
            this.map.put(key, value);
            return (V)value;
        }
        return this.map.get(key);
    }
}

