/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.InnerClassNode;

public class OrderInnerOutterInsnNodeClassAdapter
extends ClassAdapter
implements Comparator<InnerClassNode> {
    private final List<InnerClassNode> innerClassNodes = new ArrayList<InnerClassNode>(5);

    public OrderInnerOutterInsnNodeClassAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        InnerClassNode icn = new InnerClassNode(name, outerName, innerName, access);
        this.innerClassNodes.add(icn);
    }

    public void visitEnd() {
        Collections.sort(this.innerClassNodes, this);
        if (this.innerClassNodes.size() > 0) {
            for (InnerClassNode icn : this.innerClassNodes) {
                icn.accept(this.cv);
            }
        }
        super.visitEnd();
    }

    @Override
    public int compare(InnerClassNode o1, InnerClassNode o2) {
        return o1.name.compareTo(o2.name);
    }
}

