/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.Date;
import fan.sys.DateTime;
import fan.sys.Err;
import fan.sys.FanInt;
import fan.sys.Locale;
import fan.sys.Month;
import fan.sys.ParseErr;
import fan.sys.Time;
import fan.sys.TimeZone;
import fan.sys.Weekday;

class DateTimeStr {
    final String pattern;
    int year;
    Month mon;
    int day;
    int hour;
    int min;
    int sec;
    int ns;
    Weekday weekday;
    TimeZone tz;
    String tzName;
    int tzOffset;
    boolean dst;
    Locale locale;
    String str;
    int pos;

    DateTimeStr(String string, Locale locale, DateTime dateTime) {
        this.pattern = string;
        this.locale = locale;
        this.year = dateTime.getYear();
        this.mon = dateTime.month();
        this.day = dateTime.getDay();
        this.hour = dateTime.getHour();
        this.min = dateTime.getMin();
        this.sec = dateTime.getSec();
        this.ns = dateTime.getNanoSec();
        this.weekday = dateTime.weekday();
        this.tz = dateTime.tz();
        this.dst = dateTime.dst();
    }

    DateTimeStr(String string, Locale locale, Date date) {
        this.pattern = string;
        this.locale = locale;
        this.year = date.getYear();
        this.mon = date.month();
        this.day = date.getDay();
        try {
            this.weekday = date.weekday();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    DateTimeStr(String string, Locale locale, Time time) {
        this.pattern = string;
        this.locale = locale;
        this.hour = time.getHour();
        this.min = time.getMin();
        this.sec = time.getSec();
        this.ns = time.getNanoSec();
    }

    DateTimeStr(String string, Locale locale) {
        this.pattern = string;
        this.locale = locale;
    }

    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.pattern.length();
        block62: for (int i = 0; i < n; ++i) {
            char c = this.pattern.charAt(i);
            if (c == '\'') {
                while (true) {
                    if (++i >= n) {
                        throw ArgErr.make("Invalid pattern: unterminated literal");
                    }
                    c = this.pattern.charAt(i);
                    if (c == '\'') continue block62;
                    stringBuilder.append(c);
                }
            }
            int n2 = 1;
            while (i + 1 < n && this.pattern.charAt(i + 1) == c) {
                ++i;
                ++n2;
            }
            boolean bl = false;
            block0 : switch (c) {
                case 'Y': {
                    int n3 = this.year;
                    switch (n2) {
                        case 2: {
                            if ((n3 %= 100) < 10) {
                                stringBuilder.append('0');
                            }
                        }
                        case 4: {
                            stringBuilder.append(n3);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 'M': {
                    switch (n2) {
                        case 4: {
                            stringBuilder.append(this.mon.full(this.locale()));
                            break block0;
                        }
                        case 3: {
                            stringBuilder.append(this.mon.abbr(this.locale()));
                            break block0;
                        }
                        case 2: {
                            if (this.mon.ordinal() + 1L < 10L) {
                                stringBuilder.append('0');
                            }
                        }
                        case 1: {
                            stringBuilder.append(this.mon.ordinal() + 1L);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 'D': {
                    switch (n2) {
                        case 3: {
                            stringBuilder.append(this.day).append(DateTimeStr.daySuffix(this.day));
                            break block0;
                        }
                        case 2: {
                            if (this.day < 10) {
                                stringBuilder.append('0');
                            }
                        }
                        case 1: {
                            stringBuilder.append(this.day);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 'W': {
                    switch (n2) {
                        case 4: {
                            stringBuilder.append(this.weekday.full(this.locale()));
                            break block0;
                        }
                        case 3: {
                            stringBuilder.append(this.weekday.abbr(this.locale()));
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 'h': 
                case 'k': {
                    int n4 = this.hour;
                    if (c == 'k') {
                        if (n4 == 0) {
                            n4 = 12;
                        } else if (n4 > 12) {
                            n4 -= 12;
                        }
                    }
                    switch (n2) {
                        case 2: {
                            if (n4 < 10) {
                                stringBuilder.append('0');
                            }
                        }
                        case 1: {
                            stringBuilder.append(n4);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 'm': {
                    switch (n2) {
                        case 2: {
                            if (this.min < 10) {
                                stringBuilder.append('0');
                            }
                        }
                        case 1: {
                            stringBuilder.append(this.min);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 's': {
                    switch (n2) {
                        case 2: {
                            if (this.sec < 10) {
                                stringBuilder.append('0');
                            }
                        }
                        case 1: {
                            stringBuilder.append(this.sec);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 'S': {
                    if (this.sec == 0 && this.ns == 0) break;
                    switch (n2) {
                        case 2: {
                            if (this.sec < 10) {
                                stringBuilder.append('0');
                            }
                        }
                        case 1: {
                            stringBuilder.append(this.sec);
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 'a': {
                    switch (n2) {
                        case 1: {
                            stringBuilder.append(this.hour < 12 ? "a" : "p");
                            break block0;
                        }
                        case 2: {
                            stringBuilder.append(this.hour < 12 ? "am" : "pm");
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 'A': {
                    switch (n2) {
                        case 1: {
                            stringBuilder.append(this.hour < 12 ? "A" : "P");
                            break block0;
                        }
                        case 2: {
                            stringBuilder.append(this.hour < 12 ? "AM" : "PM");
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                case 'F': 
                case 'f': {
                    int n5 = 0;
                    int n6 = 0;
                    if (c == 'F') {
                        n6 = n2;
                    } else {
                        n5 = n2;
                        while (i + 1 < n && this.pattern.charAt(i + 1) == 'F') {
                            ++i;
                            ++n6;
                        }
                    }
                    int n7 = this.ns;
                    int n8 = 100000000;
                    for (int j = 0; j < 9; ++j) {
                        if (n5 > 0) {
                            --n5;
                        } else {
                            if (n7 == 0 || n6 <= 0) break block0;
                            --n6;
                        }
                        stringBuilder.append(n7 / n8);
                        n7 %= n8;
                        n8 /= 10;
                    }
                    break;
                }
                case 'z': {
                    int n8;
                    TimeZone.Rule rule = this.tz.rule(this.year);
                    switch (n2) {
                        case 1: {
                            n8 = rule.offset;
                            if (this.dst) {
                                n8 += rule.dstOffset;
                            }
                            if (n8 == 0) {
                                stringBuilder.append('Z');
                                break block0;
                            }
                            if (n8 < 0) {
                                stringBuilder.append('-');
                                n8 = -n8;
                            } else {
                                stringBuilder.append('+');
                            }
                            int n9 = n8 / 3600;
                            int n10 = n8 % 3600 / 60;
                            if (n9 < 10) {
                                stringBuilder.append('0');
                            }
                            stringBuilder.append(n9).append(':');
                            if (n10 < 10) {
                                stringBuilder.append('0');
                            }
                            stringBuilder.append(n10);
                            break block0;
                        }
                        case 3: {
                            stringBuilder.append(this.dst ? rule.dstAbbr : rule.stdAbbr);
                            break block0;
                        }
                        case 4: {
                            stringBuilder.append(this.tz.name());
                            break block0;
                        }
                    }
                    bl = true;
                    break;
                }
                default: {
                    int n8;
                    if (FanInt.isAlpha(c)) {
                        throw ArgErr.make("Invalid pattern: unsupported char '" + (char)c + "'");
                    }
                    if (i + 1 < n && ((n8 = (int)this.pattern.charAt(i + 1)) == 70 && this.ns == 0 || n8 == 83 && this.sec == 0 && this.ns == 0)) break;
                    stringBuilder.append(c);
                }
            }
            if (!bl) continue;
            throw ArgErr.make("Invalid pattern: unsupported num of '" + (char)c + "' (x" + n2 + ")");
        }
        return stringBuilder.toString();
    }

    private static String daySuffix(int n) {
        switch (n) {
            case 1: 
            case 21: 
            case 31: {
                return "st";
            }
            case 2: 
            case 22: {
                return "nd";
            }
            case 3: 
            case 23: {
                return "rd";
            }
        }
        return "th";
    }

    DateTime parseDateTime(String string, TimeZone timeZone, boolean bl) {
        try {
            this.tzOffset = Integer.MAX_VALUE;
            this.parse(string);
            TimeZone.Rule rule = timeZone.rule(this.year);
            if (this.tzName != null) {
                if (this.tzName.equals(timeZone.name()) || this.tzName.equals(rule.stdAbbr) || this.tzName.equals(rule.dstAbbr)) {
                    this.tz = timeZone;
                } else {
                    this.tz = TimeZone.fromStr(this.tzName, false);
                    if (this.tz == null) {
                        this.tz = timeZone;
                    }
                }
            } else if (this.tzOffset != Integer.MAX_VALUE) {
                int n = this.hour * 3600 + this.min * 60 + this.sec;
                int n2 = rule.offset + TimeZone.dstOffset(rule, this.year, (int)this.mon.ordinal(), this.day, n);
                this.tz = this.tzOffset == n2 ? timeZone : TimeZone.fromGmtOffset(this.tzOffset);
            } else {
                this.tz = timeZone;
            }
            return new DateTime(this.year, (int)this.mon.ordinal(), this.day, this.hour, this.min, this.sec, this.ns, this.tzOffset, this.tz);
        }
        catch (Exception exception) {
            if (bl) {
                throw ParseErr.make("DateTime", string, Err.make(exception));
            }
            return null;
        }
    }

    Date parseDate(String string, boolean bl) {
        try {
            this.parse(string);
            return new Date(this.year, (int)this.mon.ordinal(), this.day);
        }
        catch (Exception exception) {
            if (bl) {
                throw ParseErr.make("Date", string, Err.make(exception));
            }
            return null;
        }
    }

    Time parseTime(String string, boolean bl) {
        try {
            this.parse(string);
            return new Time(this.hour, this.min, this.sec, this.ns);
        }
        catch (Exception exception) {
            if (bl) {
                throw ParseErr.make("Time", string, Err.make(exception));
            }
            return null;
        }
    }

    private void parse(String string) {
        this.str = string;
        this.pos = 0;
        int n = this.pattern.length();
        boolean bl = false;
        block22: for (int i = 0; i < n; ++i) {
            char c = this.pattern.charAt(i);
            int n2 = 1;
            while (i + 1 < n && this.pattern.charAt(i + 1) == c) {
                ++i;
                ++n2;
            }
            switch (c) {
                case 'Y': {
                    this.year = this.parseInt(n2);
                    if (this.year < 30) {
                        this.year += 2000;
                        continue block22;
                    }
                    if (this.year >= 100) continue block22;
                    this.year += 1900;
                    continue block22;
                }
                case 'M': {
                    switch (n2) {
                        case 4: {
                            this.mon = this.parseMon();
                            continue block22;
                        }
                        case 3: {
                            this.mon = this.parseMon();
                            continue block22;
                        }
                    }
                    this.mon = Month.array[this.parseInt(n2) - 1];
                    continue block22;
                }
                case 'D': {
                    if (n2 != 3) {
                        this.day = this.parseInt(n2);
                        continue block22;
                    }
                    this.day = this.parseInt(1);
                    this.skipWord();
                    continue block22;
                }
                case 'h': 
                case 'k': {
                    this.hour = this.parseInt(n2);
                    continue block22;
                }
                case 'm': {
                    this.min = this.parseInt(n2);
                    continue block22;
                }
                case 's': {
                    this.sec = this.parseInt(n2);
                    continue block22;
                }
                case 'S': {
                    if (bl) continue block22;
                    this.sec = this.parseInt(n2);
                    continue block22;
                }
                case 'A': 
                case 'a': {
                    char c2 = this.str.charAt(this.pos);
                    this.pos += n2;
                    if (c2 == 'P' || c2 == 'p') {
                        if (this.hour >= 12) continue block22;
                        this.hour += 12;
                        continue block22;
                    }
                    if (this.hour != 12) continue block22;
                    this.hour = 0;
                    continue block22;
                }
                case 'W': {
                    this.skipWord();
                    continue block22;
                }
                case 'F': {
                    if (bl) continue block22;
                }
                case 'f': {
                    int n3;
                    this.ns = 0;
                    int n4 = 100000000;
                    while ((n3 = this.parseOptDigit()) >= 0) {
                        this.ns += n4 * n3;
                        n4 /= 10;
                    }
                    continue block22;
                }
                case 'z': {
                    switch (n2) {
                        case 1: {
                            this.parseTzOffset();
                            continue block22;
                        }
                    }
                    this.parseTzName();
                    continue block22;
                }
                case '\'': {
                    char c3;
                    int n3;
                    while ((n3 = this.pattern.charAt(++i)) != 39) {
                        if ((c3 = this.str.charAt(this.pos++)) == n3) continue;
                        throw new RuntimeException("Expected '" + (char)n3 + "', not '" + (char)c3 + "' [pos " + this.pos + "]");
                    }
                    continue block22;
                }
                default: {
                    char c3;
                    int n3;
                    int n5 = n3 = this.pos + 1 < this.str.length() ? (int)this.str.charAt(this.pos++) : 0;
                    if (i + 1 < this.pattern.length() && ((c3 = this.pattern.charAt(i + 1)) == 'F' || c3 == 'S') && n3 != c) {
                        bl = true;
                        --this.pos;
                        continue block22;
                    }
                    bl = false;
                    if (n3 == c) continue block22;
                    throw new RuntimeException("Expected '" + (char)c + "' literal char, not '" + (char)n3 + "' [pos " + this.pos + "]");
                }
            }
        }
    }

    private int parseInt(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n3 = n3 * 10 + this.parseReqDigit();
        }
        if (n == 1 && (n2 = this.parseOptDigit()) >= 0) {
            n3 = n3 * 10 + n2;
        }
        return n3;
    }

    private int parseReqDigit() {
        char c;
        if ('0' <= (c = this.str.charAt(this.pos++)) && c <= '9') {
            return c - 48;
        }
        throw new RuntimeException("Expected digit, not '" + (char)c + "' [pos " + (this.pos - 1) + "]");
    }

    private int parseOptDigit() {
        char c;
        if (this.pos < this.str.length() && '0' <= (c = this.str.charAt(this.pos)) && c <= '9') {
            ++this.pos;
            return c - 48;
        }
        return -1;
    }

    private Month parseMon() {
        Month month;
        StringBuilder stringBuilder = new StringBuilder();
        while (this.pos < this.str.length()) {
            char c = this.str.charAt(this.pos);
            if ('a' <= c && c <= 'z') {
                stringBuilder.append(c);
                ++this.pos;
                continue;
            }
            if ('A' > c || c > 'Z') break;
            stringBuilder.append((char)FanInt.lower(c));
            ++this.pos;
        }
        if ((month = this.locale().monthByName(stringBuilder.toString())) == null) {
            throw new RuntimeException("Invalid month: " + stringBuilder);
        }
        return month;
    }

    private void parseTzOffset() {
        boolean bl;
        char c = this.str.charAt(this.pos++);
        switch (c) {
            case '-': {
                bl = true;
                break;
            }
            case '+': {
                bl = false;
                break;
            }
            case 'Z': {
                this.tzOffset = 0;
                return;
            }
            default: {
                throw new RuntimeException("Unexpected tz offset char: " + (char)c + " [pos " + (this.pos - 1) + "]");
            }
        }
        int n = this.parseInt(1);
        int n2 = 0;
        if (this.pos < this.str.length()) {
            c = this.str.charAt(this.pos);
            if (c == ':') {
                ++this.pos;
                n2 = this.parseInt(1);
            } else if ('0' <= c && c <= '9') {
                n2 = this.parseInt(1);
            }
        }
        this.tzOffset = n * 3600 + n2 * 60;
        if (bl) {
            this.tzOffset = -this.tzOffset;
        }
    }

    private void parseTzName() {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        while (this.pos < this.str.length() && ('a' <= (c = this.str.charAt(this.pos)) && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '+' || c == '-' || c == '_')) {
            stringBuilder.append(c);
            ++this.pos;
        }
        this.tzName = stringBuilder.toString();
    }

    private void skipWord() {
        char c;
        while (this.pos < this.str.length() && ('a' <= (c = this.str.charAt(this.pos)) && c <= 'z' || 'A' <= c && c <= 'Z')) {
            ++this.pos;
        }
    }

    private Locale locale() {
        if (this.locale == null) {
            this.locale = Locale.cur();
        }
        return this.locale;
    }
}

