/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.ClassType;
import fan.sys.Duration;
import fan.sys.FanObj;
import fan.sys.File;
import fan.sys.Func;
import fan.sys.InStream;
import fan.sys.JavaType;
import fan.sys.List;
import fan.sys.Locale;
import fan.sys.Map;
import fan.sys.OutStream;
import fan.sys.Pod;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.Uri;
import fanx.util.EnvIndex;
import fanx.util.EnvProps;
import fanx.util.EnvScripts;
import java.util.HashMap;

public abstract class Env
extends FanObj {
    static final String noDef = "_Env_nodef_";
    static Uri configProps;
    static Uri localeEnProps;
    private Env parent;
    private EnvScripts scripts = new EnvScripts();
    private EnvProps props = new EnvProps(this);
    private EnvIndex index = new EnvIndex(this);
    private HashMap javaTypeCache = new HashMap();

    public static Env cur() {
        return Sys.curEnv;
    }

    public static void make$(Env env) {
        Env.make$(env, Env.cur());
    }

    public static void make$(Env env, Env env2) {
        env.parent = env2;
    }

    public Env() {
    }

    public Env(Env env) {
        this.parent = env;
    }

    public Type typeof() {
        return Sys.EnvType;
    }

    public String toStr() {
        return this.typeof().toString();
    }

    public final Env parent() {
        return this.parent;
    }

    public final String os() {
        return Sys.os;
    }

    public final String arch() {
        return Sys.arch;
    }

    public final String platform() {
        return Sys.platform;
    }

    public final String runtime() {
        return "java";
    }

    public final long idHash(Object object) {
        return System.identityHashCode(object);
    }

    public List args() {
        return this.parent.args();
    }

    public Map vars() {
        return this.parent.vars();
    }

    public Map diagnostics() {
        return this.parent.diagnostics();
    }

    public void gc() {
        this.parent.gc();
    }

    public String host() {
        return this.parent.host();
    }

    public String user() {
        return this.parent.user();
    }

    public InStream in() {
        return this.parent.in();
    }

    public OutStream out() {
        return this.parent.out();
    }

    public OutStream err() {
        return this.parent.err();
    }

    public String promptPassword() {
        return this.promptPassword("");
    }

    public String promptPassword(String string) {
        return this.parent.promptPassword(string);
    }

    public File homeDir() {
        return this.parent.homeDir();
    }

    public File workDir() {
        return this.parent.workDir();
    }

    public File tempDir() {
        return this.parent.tempDir();
    }

    public void exit() {
        this.exit(0L);
    }

    public void exit(long l) {
        this.parent.exit(l);
    }

    public void addShutdownHook(Func func) {
        this.parent.addShutdownHook(func);
    }

    public boolean removeShutdownHook(Func func) {
        return this.parent.removeShutdownHook(func);
    }

    public File findFile(Uri uri) {
        return this.findFile(uri, true);
    }

    public File findFile(Uri uri, boolean bl) {
        return this.parent.findFile(uri, bl);
    }

    public List findAllFiles(Uri uri) {
        return this.parent.findAllFiles(uri);
    }

    public File findPodFile(String string) {
        return this.findFile(Uri.fromStr("lib/fan/" + string + ".pod"), false);
    }

    public List findAllPodNames() {
        List list = new List(Sys.StrType);
        List list2 = this.findFile(Uri.fromStr("lib/fan/")).list();
        for (int i = 0; i < list2.sz(); ++i) {
            File file = (File)list2.get(i);
            if (file.isDir() || !"pod".equals(file.ext())) continue;
            list.add(file.basename());
        }
        return list;
    }

    public Type compileScript(File file) {
        return this.compileScript(file, null);
    }

    public Type compileScript(File file, Map map) {
        return this.scripts.compile(file, map);
    }

    public List index(String string) {
        return this.index.get(string);
    }

    public List indexKeys() {
        return this.index.keys();
    }

    public Map props(Pod pod, Uri uri, Duration duration) {
        return this.props.get(pod, uri, duration);
    }

    public String config(Pod pod, String string) {
        return this.config(pod, string, null);
    }

    public String config(Pod pod, String string, String string2) {
        return (String)this.props.get(pod, configProps, Duration.oneMin).get(string, string2);
    }

    public String locale(Pod pod, String string) {
        return this.locale(pod, string, noDef, Locale.cur());
    }

    public String locale(Pod pod, String string, String string2) {
        return this.locale(pod, string, string2, Locale.cur());
    }

    public String locale(Pod pod, String string, String string2, Locale locale) {
        Duration duration = Duration.maxVal;
        Object object = this.props(pod, locale.strProps, duration).get(string, null);
        if (object != null) {
            return (String)object;
        }
        object = this.props(pod, locale.langProps, duration).get(string, null);
        if (object != null) {
            return (String)object;
        }
        object = this.props(pod, localeEnProps, duration).get(string, null);
        if (object != null) {
            return (String)object;
        }
        if (string2 == noDef) {
            return pod + "::" + string;
        }
        return string2;
    }

    public Class loadPodClass(Pod pod) {
        return this.parent.loadPodClass(pod);
    }

    public Class[] loadTypeClasses(ClassType classType) {
        return this.parent.loadTypeClasses(classType);
    }

    public Class loadJavaClass(String string) throws Exception {
        return this.parent.loadJavaClass(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaType loadJavaType(Class clazz) {
        String string = clazz.getName();
        if (string.startsWith("fan.")) {
            throw new IllegalStateException(string);
        }
        HashMap hashMap = this.javaTypeCache;
        synchronized (hashMap) {
            JavaType javaType = (JavaType)this.javaTypeCache.get(string);
            if (javaType != null) {
                return javaType;
            }
            javaType = new JavaType(this, clazz);
            this.javaTypeCache.put(string, javaType);
            return javaType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JavaType loadJavaType(String string, String string2) {
        if (!string.startsWith("[java]")) {
            throw ArgErr.make("Unsupported FFI type: " + string + "::" + string2);
        }
        if (string.length() >= 7 && string.charAt(6) == ' ') {
            throw ArgErr.make("Java FFI qname cannot contain space: " + string + "::" + string2);
        }
        HashMap hashMap = this.javaTypeCache;
        synchronized (hashMap) {
            String string3 = JavaType.toClassName(string, string2);
            JavaType javaType = (JavaType)this.javaTypeCache.get(string3);
            if (javaType != null) {
                return javaType;
            }
            javaType = new JavaType(this, string, string2);
            this.javaTypeCache.put(string3, javaType);
            return javaType;
        }
    }

    static {
        Sys.boot();
        configProps = Uri.fromStr("config.props");
        localeEnProps = Uri.fromStr("locale/en.props");
    }
}

