/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.FanStr;
import fan.sys.Func;
import fan.sys.GenericType;
import fan.sys.Map;
import fan.sys.Sys;
import fan.sys.Type;

public class FuncType
extends GenericType {
    public final Type[] params;
    public final Type ret;
    private String sig;
    private boolean genericParameterType;

    public FuncType(Type[] typeArray, Type type) {
        super(Sys.FuncType);
        this.params = typeArray;
        this.ret = type;
        this.genericParameterType |= type.isGenericParameter();
        for (int i = 0; i < typeArray.length; ++i) {
            this.genericParameterType |= typeArray[i].isGenericParameter();
        }
    }

    public long hash() {
        return FanStr.hash(this.signature());
    }

    public boolean equals(Object object) {
        if (object instanceof FuncType) {
            FuncType funcType = (FuncType)object;
            if (this.params.length != funcType.params.length) {
                return false;
            }
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i].equals(funcType.params[i])) continue;
                return false;
            }
            return this.ret.equals(funcType.ret);
        }
        return false;
    }

    public final String signature() {
        if (this.sig == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('|');
            for (int i = 0; i < this.params.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.params[i].signature());
            }
            stringBuilder.append('-').append('>');
            stringBuilder.append(this.ret.signature());
            stringBuilder.append('|');
            this.sig = stringBuilder.toString();
        }
        return this.sig;
    }

    public boolean is(Type type) {
        if (this == type) {
            return true;
        }
        if (type instanceof FuncType) {
            FuncType funcType = (FuncType)type;
            if (funcType.ret != Sys.VoidType && !this.ret.is(funcType.ret)) {
                return false;
            }
            if (this.params.length > funcType.params.length) {
                return false;
            }
            for (int i = 0; i < this.params.length; ++i) {
                if (funcType.params[i].is(this.params[i])) continue;
                return false;
            }
            return true;
        }
        return this.base().is(type);
    }

    Map makeParams() {
        Map map = new Map(Sys.StrType, Sys.TypeType);
        for (int i = 0; i < this.params.length; ++i) {
            map.set(FanStr.ascii[65 + i], this.params[i]);
        }
        return map.set("R", this.ret).ro();
    }

    public Class toClass() {
        return Func.class;
    }

    public Type getRawType() {
        return Sys.FuncType;
    }

    public boolean isGenericParameter() {
        return this.genericParameterType;
    }

    protected Type doParameterize(Type type) {
        if (type == Sys.RType) {
            return this.ret;
        }
        int n = type.name().charAt(0) - 65;
        if (n < this.params.length) {
            return this.params[n];
        }
        return Sys.ObjType;
    }
}

