/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.ClassType;
import fan.sys.Env;
import fan.sys.Err;
import fan.sys.Facet;
import fan.sys.Facets;
import fan.sys.FanStr;
import fan.sys.Field;
import fan.sys.List;
import fan.sys.Method;
import fan.sys.NullableType;
import fan.sys.Param;
import fan.sys.Pod;
import fan.sys.Slot;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnknownSlotErr;
import fan.sys.UnknownTypeErr;
import fan.sys.UnsupportedErr;
import fanx.util.FanUtil;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class JavaType
extends Type {
    private Env env;
    private String podName;
    private String typeName;
    private Type nullable;
    private Class cls;
    private int flags = -1;
    private Type base;
    private List mixins;
    private List inheritance;
    private List fields;
    private List methods;
    private List slots;
    private HashMap slotsByName;

    JavaType(Env env, String string, String string2) {
        this.env = env;
        this.podName = string;
        this.typeName = string2;
        this.cls = null;
    }

    JavaType(Env env, Class clazz) {
        this.env = env;
        if (clazz.isArray() && clazz.getComponentType().isPrimitive()) {
            this.podName = "[java]fanx.interop";
            this.typeName = FanStr.capitalize(clazz.getComponentType().getSimpleName()) + "Array";
        } else {
            this.podName = clazz.getPackage() == null ? "[java]" : "[java]" + clazz.getPackage().getName();
            this.typeName = clazz.getSimpleName();
        }
        this.cls = clazz;
    }

    public Pod pod() {
        return null;
    }

    public String podName() {
        return this.podName;
    }

    public String name() {
        return this.typeName;
    }

    public String qname() {
        return this.podName + "::" + this.typeName;
    }

    public String signature() {
        return this.qname();
    }

    int flags() {
        return this.init().flags;
    }

    public Type base() {
        return this.init().base;
    }

    public List mixins() {
        return this.init().mixins;
    }

    public List inheritance() {
        return this.init().inheritance;
    }

    public boolean is(Type type) {
        if ((type = type.toNonNullable()) == Sys.ObjType) {
            return true;
        }
        return type.toClass().isAssignableFrom(this.toClass());
    }

    public boolean isVal() {
        return false;
    }

    public final boolean isNullable() {
        return false;
    }

    public final synchronized Type toNullable() {
        if (this.nullable == null) {
            this.nullable = new NullableType(this);
        }
        return this.nullable;
    }

    public List fields() {
        return this.initSlots().fields;
    }

    public List methods() {
        return this.initSlots().methods;
    }

    public Method method(String string, boolean bl) {
        Slot slot = this.slot(string, bl);
        if (slot instanceof Field) {
            Field field = (Field)slot;
            if (field.overload != null) {
                return field.overload;
            }
        }
        return (Method)slot;
    }

    public List slots() {
        return this.initSlots().slots;
    }

    public Slot slot(String string, boolean bl) {
        Slot slot = (Slot)this.initSlots().slotsByName.get(string);
        if (slot != null) {
            return slot;
        }
        if (bl) {
            throw UnknownSlotErr.make(this.qname() + "." + string);
        }
        return null;
    }

    public List facets() {
        return Facets.empty().list();
    }

    public Facet facet(Type type, boolean bl) {
        return Facets.empty().get(type, bl);
    }

    public String doc() {
        return null;
    }

    public boolean javaRepr() {
        return false;
    }

    private RuntimeException unsupported() {
        return new UnsupportedOperationException();
    }

    public Class toClass() {
        try {
            if (this.cls == null) {
                this.cls = this.env.loadJavaClass(JavaType.toClassName(this.podName, this.typeName));
            }
            return this.cls;
        }
        catch (Exception exception) {
            throw UnknownTypeErr.make("Cannot map Fantom type to Java class: " + this.qname(), exception);
        }
    }

    private JavaType init() {
        if (this.flags != -1) {
            return this;
        }
        try {
            Class clazz;
            Class clazz2 = this.toClass();
            this.flags = FanUtil.classModifiersToFanFlags(clazz2.getModifiers());
            if (clazz2.isAnnotation()) {
                this.flags |= 2;
            }
            this.base = (clazz = clazz2.getSuperclass()) != null ? JavaType.toFanType(clazz) : Sys.ObjType;
            Class<?>[] classArray = clazz2.getInterfaces();
            this.mixins = new List(Sys.TypeType, classArray.length);
            for (int i = 0; i < classArray.length; ++i) {
                this.mixins.add(JavaType.toFanType(classArray[i]));
            }
            this.mixins = (List)this.mixins.toImmutable();
            this.inheritance = ClassType.inheritance(this);
        }
        catch (Exception exception) {
            System.out.println("ERROR: JavaType.init: " + this);
            exception.printStackTrace();
        }
        return this;
    }

    private synchronized JavaType initSlots() {
        Object object;
        int n;
        if (this.slots != null) {
            return this;
        }
        java.lang.reflect.Field[] fieldArray = this.toClass().getFields();
        java.lang.reflect.Method[] methodArray = this.toClass().getMethods();
        List list = new List(Sys.SlotType, fieldArray.length + methodArray.length + 4);
        List list2 = new List(Sys.FieldType, fieldArray.length);
        List list3 = new List(Sys.MethodType, fieldArray.length + 4);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (n = 0; n < fieldArray.length; ++n) {
            object = this.toFan(fieldArray[n]);
            list.add(object);
            list2.add(object);
            hashMap.put(((Slot)object).name(), object);
        }
        for (n = 0; n < methodArray.length; ++n) {
            java.lang.reflect.Method[] methodArray2;
            Slot slot;
            object = methodArray[n];
            Slot slot2 = (Slot)hashMap.get(((java.lang.reflect.Method)object).getName());
            if (slot2 instanceof Field) {
                slot = (Field)slot2;
                if (((Field)slot).overload == null) {
                    methodArray2 = this.toFan((java.lang.reflect.Method)object);
                    ((Field)slot).overload = methodArray2;
                    list3.add(methodArray2);
                    continue;
                }
                slot2 = ((Field)slot).overload;
            }
            if (slot2 instanceof Method) {
                slot = (Method)slot2;
                methodArray2 = new java.lang.reflect.Method[((Method)slot).reflect.length + 1];
                System.arraycopy(((Method)slot).reflect, 0, methodArray2, 0, ((Method)slot).reflect.length);
                methodArray2[((Method)slot).reflect.length] = object;
                ((Method)slot).reflect = methodArray2;
                continue;
            }
            slot = this.toFan((java.lang.reflect.Method)object);
            list.add(slot);
            list3.add(slot);
            hashMap.put(slot.name(), slot);
        }
        this.slots = (List)list.toImmutable();
        this.fields = (List)list2.toImmutable();
        this.methods = (List)list3.toImmutable();
        this.slotsByName = hashMap;
        return this;
    }

    private Field toFan(java.lang.reflect.Field field) {
        Type type = JavaType.toFanType(field.getDeclaringClass());
        String string = field.getName();
        int n = FanUtil.memberModifiersToFanFlags(field.getModifiers());
        Facets facets = Facets.empty();
        Type type2 = JavaType.toFanType(field.getType());
        if (Modifier.isTransient(field.getModifiers())) {
            facets = Facets.makeTransient();
        }
        if (field.isEnumConstant()) {
            n |= 8;
        }
        Field field2 = new Field(type, string, n, facets, -1, type2);
        field2.reflect = field;
        return field2;
    }

    private Method toFan(java.lang.reflect.Method method) {
        Type type = JavaType.toFanType(method.getDeclaringClass());
        String string = method.getName();
        int n = FanUtil.memberModifiersToFanFlags(method.getModifiers());
        Facets facets = Facets.empty();
        Type type2 = JavaType.toFanType(method.getReturnType());
        Class<?>[] classArray = method.getParameterTypes();
        List list = new List(Sys.ParamType, classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            Param param = new Param("p" + i, JavaType.toFanType(method.getDeclaringClass()), 0);
            list.add(param);
        }
        Method method2 = new Method(type, string, n, facets, -1, type2, type2, list.ro());
        method2.reflect = new java.lang.reflect.Method[]{method};
        return method2;
    }

    public Object make(List list) {
        if (list != null && list.sz() > 0) {
            throw UnsupportedErr.make("Cannot call make with args on Java type: " + this);
        }
        try {
            return this.toClass().newInstance();
        }
        catch (Exception exception) {
            throw Err.make(exception);
        }
    }

    static Object get(Field field, Object object) throws Exception {
        java.lang.reflect.Field field2 = field.reflect;
        Class<?> clazz = field2.getType();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return field2.getLong(object);
            }
            if (clazz == Byte.TYPE) {
                return field2.getLong(object);
            }
            if (clazz == Short.TYPE) {
                return field2.getLong(object);
            }
            if (clazz == Character.TYPE) {
                return field2.getLong(object);
            }
            if (clazz == Float.TYPE) {
                return field2.getDouble(object);
            }
        }
        return JavaType.coerceFromJava(field2.get(object));
    }

    static void set(Field field, Object object, Object object2) throws Exception {
        java.lang.reflect.Field field2 = field.reflect;
        Class<?> clazz = field2.getType();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                field2.setInt(object, ((Number)object2).intValue());
                return;
            }
            if (clazz == Byte.TYPE) {
                field2.setByte(object, ((Number)object2).byteValue());
                return;
            }
            if (clazz == Short.TYPE) {
                field2.setShort(object, ((Number)object2).shortValue());
                return;
            }
            if (clazz == Character.TYPE) {
                field2.setChar(object, (char)((Number)object2).intValue());
                return;
            }
            if (clazz == Float.TYPE) {
                field2.setFloat(object, ((Number)object2).floatValue());
                return;
            }
        }
        field2.set(object, JavaType.coerceToJava(object2, clazz));
    }

    static Object invoke(Method method, Object object, Object[] objectArray) throws Exception {
        java.lang.reflect.Method method2 = JavaType.resolve(method, objectArray);
        Class<?>[] classArray = method2.getParameterTypes();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = JavaType.coerceToJava(objectArray[i], classArray[i]);
        }
        return JavaType.coerceFromJava(method2.invoke(object, objectArray));
    }

    static java.lang.reflect.Method resolve(Method method, Object[] objectArray) {
        java.lang.reflect.Method[] methodArray = method.reflect;
        if (methodArray.length == 1) {
            return methodArray[0];
        }
        java.lang.reflect.Method method2 = null;
        for (int i = 0; i < methodArray.length; ++i) {
            java.lang.reflect.Method method3 = methodArray[i];
            Class[] classArray = method3.getParameterTypes();
            if (!JavaType.argsMatchParams(objectArray, classArray)) continue;
            if (method2 == null) {
                method2 = method3;
                continue;
            }
            if (JavaType.isMoreSpecific(method2, method3)) continue;
            if (JavaType.isMoreSpecific(method3, method2)) {
                method2 = method3;
                continue;
            }
            throw ArgErr.make("Ambiguous method call '" + method.name + "'");
        }
        if (method2 != null) {
            return method2;
        }
        throw ArgErr.make("No matching method '" + method.name + "' for arguments");
    }

    static boolean argsMatchParams(Object[] objectArray, Class[] classArray) {
        if (objectArray.length != classArray.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (JavaType.argMatchesParam(objectArray[i], classArray[i])) continue;
            return false;
        }
        return true;
    }

    static boolean argMatchesParam(Object object, Class clazz) {
        if (clazz.isInstance(object)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return object instanceof Boolean;
            }
            return object instanceof Number;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                return false;
            }
            return object instanceof List;
        }
        return false;
    }

    static boolean isMoreSpecific(java.lang.reflect.Method method, java.lang.reflect.Method method2) {
        Class<?>[] classArray = method.getParameterTypes();
        Class<?>[] classArray2 = method2.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray2[i].isAssignableFrom(classArray[i])) continue;
            return false;
        }
        return true;
    }

    static Object coerceToJava(Object object, Class clazz) {
        if (clazz == Integer.TYPE) {
            return ((Number)object).intValue();
        }
        if (clazz == Byte.TYPE) {
            return ((Number)object).byteValue();
        }
        if (clazz == Short.TYPE) {
            return ((Number)object).shortValue();
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf((char)((Number)object).intValue());
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(((Number)object).floatValue());
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (object instanceof List) {
                return ((List)object).asArray(clazz2);
            }
        }
        return object;
    }

    static Object coerceFromJava(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Integer.class) {
            return ((Integer)object).longValue();
        }
        if (clazz == Byte.class) {
            return ((Byte)object).longValue();
        }
        if (clazz == Short.class) {
            return ((Short)object).longValue();
        }
        if (clazz == Character.class) {
            return (long)((Character)object).charValue();
        }
        if (clazz == Float.class) {
            return ((Float)object).doubleValue();
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                return object;
            }
            return new List(FanUtil.toFanType(clazz2, true), (Object[])object);
        }
        return object;
    }

    static String toClassName(String string, String string2) {
        return FanUtil.toJavaClassName(string, string2);
    }

    public static Type toFanType(Class clazz) {
        return FanUtil.toFanType(clazz, true);
    }
}

