/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Buf;
import fan.sys.FanInt;
import fan.sys.File;
import fan.sys.InStream;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnsupportedErr;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public class MmapBuf
extends Buf {
    private File file;
    private MappedByteBuffer mmap;
    private byte[] temp;

    MmapBuf(File file, MappedByteBuffer mappedByteBuffer) {
        this.file = file;
        this.mmap = mappedByteBuffer;
        this.out = new MmapBufOutStream();
        this.in = new MmapBufInStream();
    }

    public Type typeof() {
        return Sys.MmapBufType;
    }

    public final long size() {
        return this.mmap.limit();
    }

    public final void size(long l) {
        this.mmap.limit((int)l);
    }

    public final long pos() {
        return this.mmap.position();
    }

    final void pos(long l) {
        this.mmap.position((int)l);
    }

    public final int getByte(long l) {
        return this.mmap.get((int)l) & 0xFF;
    }

    public final void setByte(long l, int n) {
        this.mmap.put((int)l, (byte)n);
    }

    public final void getBytes(long l, byte[] byArray, int n, int n2) {
        int n3 = this.mmap.position();
        this.mmap.position((int)l);
        this.mmap.get(byArray, n, n2);
        this.mmap.position(n3);
    }

    public final void pipeTo(byte[] byArray, int n, int n2) {
        this.mmap.get(byArray, n, n2);
    }

    public final void pipeTo(OutputStream outputStream, long l) throws IOException {
        int n;
        byte[] byArray = this.temp();
        int n2 = (int)l;
        for (int i = 0; i < n2; i += n) {
            n = Math.min(byArray.length, n2 - i);
            this.mmap.get(byArray, 0, n);
            outputStream.write(byArray, 0, n);
        }
    }

    public final void pipeTo(RandomAccessFile randomAccessFile, long l) throws IOException {
        int n;
        byte[] byArray = this.temp();
        int n2 = (int)l;
        for (int i = 0; i < n2; i += n) {
            n = Math.min(byArray.length, n2 - i);
            this.mmap.get(byArray, 0, n);
            randomAccessFile.write(byArray, 0, n);
        }
    }

    public final void pipeTo(ByteBuffer byteBuffer, int n) {
        this.pipe(this.mmap, byteBuffer, n);
    }

    void pipe(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
        int n2;
        byte[] byArray = this.temp();
        for (int i = 0; i < n; i += n2) {
            n2 = Math.min(byArray.length, n - i);
            byteBuffer.get(byArray, 0, n2);
            byteBuffer2.put(byArray, 0, n2);
        }
    }

    public final void pipeFrom(byte[] byArray, int n, int n2) {
        this.mmap.put(byArray, n, n2);
    }

    public final long pipeFrom(InputStream inputStream, long l) throws IOException {
        int n;
        int n2;
        byte[] byArray = this.temp();
        int n3 = (int)l;
        for (n = 0; n < n3; n += n2) {
            n2 = inputStream.read(byArray, 0, Math.min(byArray.length, n3 - n));
            if (n2 < 0) {
                return n == 0 ? -1L : (long)n;
            }
            this.mmap.put(byArray, 0, n2);
        }
        return n;
    }

    public final long pipeFrom(RandomAccessFile randomAccessFile, long l) throws IOException {
        int n;
        int n2;
        byte[] byArray = this.temp();
        int n3 = (int)l;
        for (n = 0; n < n3; n += n2) {
            n2 = randomAccessFile.read(byArray, 0, Math.min(byArray.length, n3 - n));
            if (n2 < 0) {
                return n == 0 ? -1L : (long)n;
            }
            this.mmap.put(byArray, 0, n2);
        }
        return n;
    }

    public final int pipeFrom(ByteBuffer byteBuffer, int n) {
        this.pipe(byteBuffer, this.mmap, n);
        return n;
    }

    public long capacity() {
        return this.size();
    }

    public void capacity(long l) {
        throw UnsupportedErr.make("mmap capacity fixed");
    }

    public final Buf flush() {
        this.mmap.force();
        return this;
    }

    public final boolean close() {
        return true;
    }

    public final String toHex() {
        throw UnsupportedErr.make();
    }

    public Buf toDigest(String string) {
        throw UnsupportedErr.make();
    }

    final byte[] temp() {
        if (this.temp == null) {
            this.temp = new byte[1024];
        }
        return this.temp;
    }

    class MmapBufInStream
    extends InStream {
        MmapBufInStream() {
        }

        public Long read() {
            int n = this.r();
            return n < 0 ? null : FanInt.pos[n];
        }

        public int r() {
            if (MmapBuf.this.mmap.remaining() <= 0) {
                return -1;
            }
            return MmapBuf.this.mmap.get() & 0xFF;
        }

        public Long readBuf(Buf buf, long l) {
            int n;
            int n2 = MmapBuf.this.mmap.remaining();
            if (n2 <= 0) {
                return null;
            }
            if ((long)n2 < l) {
                l = n2;
            }
            if ((n = buf.pipeFrom(MmapBuf.this.mmap, (int)l)) < 0) {
                return null;
            }
            return n;
        }

        public InStream unread(long l) {
            return this.unread((int)l);
        }

        public InStream unread(int n) {
            MmapBuf.this.mmap.put(MmapBuf.this.mmap.position() - 1, (byte)n);
            return this;
        }

        public Long peek() {
            return FanInt.pos[MmapBuf.this.mmap.get(MmapBuf.this.mmap.position())];
        }
    }

    class MmapBufOutStream
    extends OutStream {
        MmapBufOutStream() {
        }

        public final OutStream write(long l) {
            return this.w((int)l);
        }

        public final OutStream w(int n) {
            MmapBuf.this.mmap.put((byte)n);
            return this;
        }

        public OutStream writeBuf(Buf buf, long l) {
            buf.pipeTo(MmapBuf.this.mmap, (int)l);
            return this;
        }

        public OutStream writeChar(long l) {
            this.charsetEncoder.encode((char)l, this);
            return this;
        }

        public OutStream writeChar(char c) {
            this.charsetEncoder.encode(c, this);
            return this;
        }

        public OutStream flush() {
            MmapBuf.this.flush();
            return this;
        }
    }
}

