/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.FanObj;
import fan.sys.IndexErr;
import fan.sys.OutStream;
import fan.sys.Range;
import fan.sys.StrBufOutStream;
import fan.sys.Sys;
import fan.sys.Type;

public class StrBuf
extends FanObj {
    StringBuilder sb;

    public static StrBuf make() {
        return new StrBuf(new StringBuilder(16));
    }

    public static StrBuf make(long l) {
        return new StrBuf(new StringBuilder((int)l));
    }

    public StrBuf(StringBuilder stringBuilder) {
        this.sb = stringBuilder;
    }

    public boolean isEmpty() {
        return this.sb.length() == 0;
    }

    public long size() {
        return this.sb.length();
    }

    public long capacity() {
        return this.sb.capacity();
    }

    public void capacity(long l) {
        this.sb.ensureCapacity((int)l);
    }

    public long get(long l) {
        int n = (int)l;
        if (n < 0) {
            n = this.sb.length() + n;
        }
        return this.sb.charAt(n);
    }

    public StrBuf set(long l, long l2) {
        int n = (int)l;
        if (n < 0) {
            n = this.sb.length() + n;
        }
        this.sb.setCharAt(n, (char)l2);
        return this;
    }

    public StrBuf add(Object object) {
        String string = object == null ? "null" : StrBuf.toStr(object);
        this.sb.append(string);
        return this;
    }

    public StrBuf addChar(long l) {
        this.sb.append((char)l);
        return this;
    }

    public StrBuf join(Object object) {
        return this.join(object, " ");
    }

    public StrBuf join(Object object, String string) {
        String string2;
        String string3 = string2 = object == null ? "null" : StrBuf.toStr(object);
        if (this.sb.length() > 0) {
            this.sb.append(string);
        }
        this.sb.append(string2);
        return this;
    }

    public StrBuf insert(long l, Object object) {
        String string = object == null ? "null" : StrBuf.toStr(object);
        int n = (int)l;
        if (n < 0) {
            n = this.sb.length() + n;
        }
        if (n > this.sb.length()) {
            throw IndexErr.make(l);
        }
        this.sb.insert(n, string);
        return this;
    }

    public StrBuf remove(long l) {
        int n = (int)l;
        if (n < 0) {
            n = this.sb.length() + n;
        }
        if (n >= this.sb.length()) {
            throw IndexErr.make(l);
        }
        this.sb.delete(n, n + 1);
        return this;
    }

    public StrBuf removeRange(Range range) {
        int n = range.start(this.sb.length());
        int n2 = range.end(this.sb.length());
        int n3 = n2 - n + 1;
        if (n3 < 0) {
            throw IndexErr.make(range);
        }
        this.sb.delete(n, n2 + 1);
        return this;
    }

    public StrBuf clear() {
        this.sb.setLength(0);
        return this;
    }

    public String toStr() {
        return this.sb.toString();
    }

    public Type typeof() {
        return Sys.StrBufType;
    }

    public OutStream out() {
        return new StrBufOutStream(this);
    }
}

