// (c) Microsoft Corporation 2005-2007.

#light

namespace Microsoft.FSharp.Collections

open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Core.Operators
open Microsoft.FSharp.Collections
#if CLI_AT_MOST_1_1
open Microsoft.FSharp.Compatibility
#else
open System.Collections.Generic
#endif

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Set = 

    type Set<'a> = Microsoft.FSharp.Collections.Set<'a>
    type 'a t = Set<'a>  


    let empty<'a> : Set<'a> = Set.Empty()
    let is_empty (s : Set<'a>) = s.IsEmpty
    let mem x (s : Set<'a>) = s.Contains(x)
    let add x (s : Set<'a>) = s.Add(x)
    let singleton x = Set.Singleton(x)
    let remove x (s : Set<'a>) = s.Remove(x)
    let union (s1 : Set<'a>)  (s2 : Set<'a>)  = Set.Union(s1,s2)
    let inter (s1 : Set<'a>)  (s2 : Set<'a>)  = Set.Intersection(s1,s2)
    let diff (s1 : Set<'a>)  (s2 : Set<'a>)   = Set.Difference(s1,s2)
    let iter f (s : Set<'a>)  = s.Iterate(f)
    let elements (s : Set<'a>) = s.ToList()
    let equal (s1 : Set<'a>)  (s2 : Set<'a>)  =  Set.Equality(s1,s2)
    let subset (s1 : Set<'a>)  (s2 : Set<'a>)  = s1.IsSubsetOf(s2)
    let compare (s1 : Set<'a>)  (s2 : Set<'a>) = Set.Compare(s1,s2)
    let for_all f (s : Set<'a>) = s.ForAll f
    let exists f (s : Set<'a>) = s.Exists f
    let filter f (s : Set<'a>) = s.Filter f
    let partition f (s : Set<'a>) = s.Partition f 
    let fold f (s : Set<'a>) acc = s.Fold f acc
    let map f (s : Set<'a>) = s.Map f
    let cardinal (s : Set<'a>) = s.Count
    let size (s : Set<'a>) = s.Count
    let min_elt (s : Set<'a>) = s.MinimumElement
    let max_elt (s : Set<'a>) = s.MaximumElement
    let choose (s : Set<'a>) = s.Choose

    let of_list l = Set.Create (List.to_seq l)
    let of_array (l : 'a array) = Set.FromArray(l)

    let to_list (s : Set<'a>) = s.ToList()
    let to_array (s : Set<'a>) = s.ToArray()

    let to_seq (s : Set<'a>) = (s :> seq<'a>)
    let of_seq (c : #seq<_>) = Set.Create(c)
    let to_IEnumerable s = to_seq s
    let of_IEnumerable c = of_seq c
    #if CLI_AT_LEAST_2_0
    let to_ICollection (s : Set<'a>) = (s :> ICollection<'a>)
    let of_ICollection (c : #ICollection<_>) = of_IEnumerable(c)
      

    #endif


