(* (c) Microsoft Corporation. All rights reserved *)
(*F# 
module Microsoft.FSharp.Compiler.Creflect
open Microsoft.FSharp.Compiler 
F#*) 

(* Convert quoted TAST data structures to structures ready for pickling *)

open Tast
open Tastops

type cenv 
val mk_cenv : Env.tcGlobals * Import.importMap * ccu * Ast.niceNameGenerator -> cenv
type env
val empty_env : env 
val bind_typars : env -> typar_spec list -> env 
exception InvalidQuotedTerm of exn
exception IgnoringPartOfQuotedTermWarning of string * Range.range
val convExpr : cenv -> env -> expr -> Sreflect.Raw.expr 
val conv_type : cenv -> env -> Range.range -> typ -> Sreflect.Raw.dtype 
val conv_typar : cenv -> env -> typar_spec -> Sreflect.Raw.dtypeVar 
