(*  (c) Microsoft Corporation 2005-2007.  *)

/// Pseudo-polymorphic 2-dimensional arrays.  Only really used when working with .NET 1.x.
///
/// For any particular 'a , the "'a[,]" type is type-compatible with 
/// the corresponding C# 2-dimensional array type. The module contains
/// operations to manipulate these values.  The operations may be used 
/// on any version of the .NET CLR.  See the 'Advanced' section of 
/// the manual for when 'Compatibility' array operations are needed to write
/// code that will function on any version of the CLR.
///
/// <example>
/// See the sample fsharp/Automation/Excel for an example of passing one of
/// these values to fill in the cells of an Excel spreadsheet.
/// </example>
module Microsoft.FSharp.Compatibility.CompatMatrix 
open Microsoft.FSharp.Core
open Microsoft.FSharp.Collections

#if CLI_AT_LEAST_2_0
/// Create a new array of the given lengths, each entry of which holds the given element
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val create: int -> int -> 'a -> 'a[,]
/// Fetch the given element of the array
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val get: 'a[,] -> int -> int -> 'a
/// Build a new array whose elements are f 0 0, f 0 1, ..., f N N
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val init: int -> int -> (int -> int -> 'a) -> 'a[,]
/// Execute the given function for each element of the given array
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val iter: ('a -> unit) -> 'a[,] -> unit
/// Execute the given function for each element of the given array.  The integer
/// indices indicate the index of the element.
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val iteri: (int -> int -> 'a -> unit) -> 'a[,] -> unit
/// The length of the array in the first dimension
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val length1: 'a[,] -> int
/// The length of the array in the second dimension
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val length2: 'a[,] -> int
/// Build a new array of the given length, each entry of which holds the given element.
/// Same as create.
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val make: int -> int -> 'a -> 'a[,]
/// Build a new array whose elements are the results of applying the given function
/// to each of the elements of the array.
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val map: ('a -> 'b) -> 'a[,] -> 'b[,]
/// Build a new array whose elements are the results of applying the given function
/// to each of the elements of the array. The integer
/// indices passed to the funciton indicates the indices of the element.
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val mapi: (int -> int -> 'a -> 'b) -> 'a[,] -> 'b[,]
/// Set the given element of the array
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val set: 'a[,] -> int -> int -> 'a -> unit
/// Create a new array filled with zero (null or default) values.  Warning: Use of this
/// function may result in subsequent exceptions if the elements of the array
/// are accessed before initialized.
[<System.Obsolete("The Microsoft.FSharp.Compatibility.CompatArray2 module is now deprecated on .NET 2.0, and will be deleted in a later release of F#. Use the corresponding functions from the Array2 module instead")>]
val zero_create: int -> int -> 'a[,]

#else

/// Create a new array of the given lengths, each entry of which holds the given element
val inline create: int -> int -> $a -> $a[,]
/// Fetch the given element of the array
val inline get: $a[,] -> int -> int -> $a
/// Build a new array whose elements are f 0 0, f 0 1, ..., f N N
val inline init: int -> int -> (int -> int -> $a) -> $a[,]
/// Execute the given function for each element of the given array
val inline iter: ($a -> unit) -> $a[,] -> unit
/// Execute the given function for each element of the given array.  The integer
/// indices indicate the index of the element.
val inline iteri: (int -> int -> $a -> unit) -> $a[,] -> unit
/// The length of the array in the first dimension
val inline length1: $a[,] -> int
/// The length of the array in the second dimension
val inline length2: $a[,] -> int
/// Build a new array of the given length, each entry of which holds the given element.
/// Same as create.
val inline make: int -> int -> $a -> $a[,]
/// Build a new array whose elements are the results of applying the given function
/// to each of the elements of the array.
val inline map: ($a -> $b) -> $a[,] -> $b[,]
/// Build a new array whose elements are the results of applying the given function
/// to each of the elements of the array. The integer
/// indices passed to the funciton indicates the indices of the element.
val inline mapi: (int -> int -> $a -> $b) -> $a[,] -> $b[,]
/// Set the given element of the array
val inline set: $a[,] -> int -> int -> $a -> unit
/// Create a new array filled with zero (null or default) values.  Warning: Use of this
/// function may result in subsequent exceptions if the elements of the array
/// are accessed before initialized.
val inline zero_create: int -> int -> $a[,]

#endif
